<?php

namespace App\Http\Controllers\Web\Admin;

use App\Http\Controllers\Controller;
use App\Imports\SchoolImport;
use App\Models\School;
use App\RequestRules\Web\SchoolRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Maatwebsite\Excel\Facades\Excel;


class SchoolController extends Controller
{
    /**
     * Get schools view
     *
     * @return Application|Factory|View|\Illuminate\Foundation\Application
     */
    public function index(): \Illuminate\Foundation\Application|View|Factory|Application
    {
        $schools = School::allSchools();

        return view("admin.school.index", compact("schools"));
    }

    /**
     * Import schools
     *
     * @param Request $request
     * @return RedirectResponse
     */
    public function import(Request $request): RedirectResponse
    {
      $request->validate(SchoolRules::import());

        Excel::import(new SchoolImport, $request->file('schools'));

        return Redirect::route('schools.index')->with("success", __("messages.record_successfully_created"));
    }
}
