<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\SubjectGroup;
use App\RequestRules\Api\SubjectRules;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SubjectController extends Controller
{

    /**
     * Get class Subjects
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public  function getClassSubjects(Request $request): Application|ResponseFactory|Response
    {
        $data = $request->all();

        $subjectGroupClass = null;

        if($data["type"] == config('minesec.education_type.general')) {
            $request->validate(SubjectRules::getGeneralEducationClassSubjects());

            $subjectGroupClass = SubjectGroup::getClassSubjects($data["type"], $data);
        }

        if($data["type"] == config('minesec.education_type.technical')) {
            $request->validate(SubjectRules::getTechnicalEducationClassSubjects());

            $subjectGroupClass = SubjectGroup::getClassSubjects($data["type"], $data);
        }

        if($data["type"] == config('minesec.education_type.teacher_training')) {
            $request->validate(SubjectRules::getTeacherTrainingClassSubjects());

            $subjectGroupClass = SubjectGroup::getClassSubjects($data["type"], $data);
        }

        if($subjectGroupClass == null) {
            return api_response(150, 'No subjects found');
        }

        $subjectGroup = SubjectGroup::findById($subjectGroupClass->{"subject_group_id"});
        $subjectGroupResults = array();

        foreach ($subjectGroup->{"subjectGroupSubjects"} as $subject) {
            $subjectGroupResults[] = array(
                "id" => $subject->{"id"},
                "designation" => $subject->{"designation"}
            );
        }

        return api_response(100, 'ok', $subjectGroupResults);
    }
}
