<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Lesson;
use Illuminate\Http\Request;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class LessonController extends Controller
{
    /**
     * @return Application|ResponseFactory|Response
     */
    public  function index(): Response|Application|ResponseFactory
    {
        $lessons = Lesson::allLessons();

        if(count($lessons) == 0) {
            return api_response(150, 'No lessons found');
        }

        $lessonArray = array();
        foreach ($lessons as $lesson) {
            $lessonArray[] = array(
                "id" => $lesson->{"id"},
                "title" => $lesson->{"title"},
                "description" => $lesson->{"description"},
//                "path" => url($lesson->{"path"}),
                "path" => Storage::url($lesson->{"path"}),
                "duration" => $lesson->{"duration"},
//                "visibility" => Storage::getVisibility($lesson->{"path"}),
                "lesson_image" => Storage::url($lesson->{"thumbnail"}),
            );
        }

        return api_response(100, 'ok', $lessonArray);
    }

    /**
     * Get subject lessons
     *
     * @param Request $request
     * @return Application|ResponseFactory|Response
     */
    public function getSubjectLessons(Request $request): Response|Application|ResponseFactory
    {
        $data = $request->all();

        $response  = Lesson::subjectLessons($data);

        if(count($response) == 0) {
            return api_response(150, 'No lessons found');
        }


        $lessonArray = array();
        foreach ($response as $lesson) {
            $path = Storage::disk('local')->path($lesson->{"path"});
            $lessonArray[] = array(
                "id" => $lesson->{"id"},
                "title" => $lesson->{"title"},
                "description" => $lesson->{"description"},
//                "path" =>  URL::to('/'.$lesson->{"path"}),
                "path" => url('storage/' . $lesson->{"path"}),
                "duration" => $lesson->{"duration"},
//                "visibility" => Storage::getVisibility($lesson->{"path"}),
               "lesson_image" => url('storage/' . $lesson->{"thumbnail"}),
            );
        }

        return api_response(100, 'ok', $lessonArray);
    }
}
