<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.png')); ?>" type="image/png" />

    <!--plugins-->
    <link href="<?php echo e(asset('assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />

    <!-- loader-->
    <link href="<?php echo e(asset('assets/css/pace.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('assets/js/pace.min.js')); ?>"></script>

    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet">
    <title><?php echo e(__(config('app.name'))); ?></title>

        <link href="assets/plugins/smart-wizard/css/smart_wizard_all.min.css" rel="stylesheet" type="text/css" />

</head>

<body class="bg-login">
<!--wrapper-->
<div class="wrapper">
    <?php if ($__env->exists('layouts.default.header')) echo $__env->make('layouts.default.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <h6 class="mb-0 text-uppercase">Basic Form</h6>
                <hr/>
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">

                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bxs-user me-1 font-22 text-primary"></i>
                            </div>
                            <h5 class="mb-0 text-primary"> DATA COLLECTION FORM</h5>
                        </div>
                        <hr>

                        <!-- SmartWizard html -->
                        <div id="smartwizard">
                            <ul class="nav">
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-1">	<strong>Step 1</strong>
                                        <br>Identification of the school</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-2">	<strong>Step 2</strong>
                                        <br>Administration</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-3">	<strong>Step 3</strong>
                                        <br>CP1 Form</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-4">	<strong>Step 4</strong>
                                        <br>Identification of main problems</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div id="step-1" class="tab-pane" role="tabpanel" aria-labelledby="step-1">
                                    <br>
                                    <!-- End of step 1 html -->
                                    <form class="row g-3">
                                        <div class="col-md-6">
                                            <B> <label class="form-label"><?php echo e(__("messages.name_of_school")); ?> </label></B>
                                            <input type="text" name="name_of_school" class="form-control" id="inputFirstName">
                                        </div>
                                        <div class="col-md-6">
                                            <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.school_code")); ?></label></B>
                                            <input type="text" name="school_code" class="form-control" id="inputLastName">
                                        </div>
                                        <div class="col-md-3">
                                            <B> <label for="inputPassword" class="form-label"><?php echo e(__("messages.name_of_school_head")); ?></label></B>
                                            <input type="text" name="name_of_school_head" class="form-control" >
                                        </div>
                                        <div class="col-md-3">
                                            <B>  <label for="inputEmail" class="form-label"><?php echo e(__("messages.matricule")); ?></label></B>
                                            <input type="text" class="form-control" name="matricule">
                                        </div>
                                        <div class="col-md-3">
                                            <B> <label for="inputPassword" class="form-label"><?php echo e(__("messages.grade")); ?></label></B>
                                            <input type="text" class="form-control" name="grade">
                                        </div>
                                        <div class="col-md-3">
                                            <B> <label for="inputPassword" class="form-label"><?php echo e(__("messages.contact")); ?></label></B>
                                            <input type="text" class="form-control" name="contact">
                                        </div>

                                        <div class="col-md-3">
                                            <B> <label for="inputPassword" class="form-label"><?php echo e(__("messages.region")); ?></label></B>

                                            <select class="form-select mb-3" aria-label="Default select example">
                                                <option selected>Open this select menu</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>

                                        </div>
                                        <div class="col-md-3">
                                            <B>  <label for="inputEmail" class="form-label"><?php echo e(__("messages.division")); ?></label> </B>

                                            <select class="form-select mb-3" aria-label="Default select example" name="division" >
                                                <option selected>Open this select menu</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <B> <label for="inputPassword" class="form-label"><?php echo e(__("messages.sub-division")); ?></label> </B>
                                            <select class="form-select mb-3" aria-label="Default select example" name="sub_division" >
                                                <option selected>Open this select menu</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <B> <label for="inputPassword" class="form-label"><?php echo e(__("messages.name_of_school")); ?></label> </B>
                                            <input type="text" class="form-control" id="inputPassword" name="name_of_school" >
                                        </div>

                                        <div class="col-md-4">
                                            <B> <label class="form-label">Type of School</label> </B>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type_of_school" id="flexRadioDefault1">
                                                <label class="form-check-label" for="flexRadioDefault1">Secondary General Education</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type_of_school" id="flexRadioDefault2" >
                                                <label class="form-check-label" for="flexRadioDefault2">Technical public Education</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type_of_school" id="flexRadioDefault2" >
                                                <label class="form-check-label" for="flexRadioDefault2">Teachers Training</label>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <B> <label class="form-label">Sector</label> </B>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="sector" id="flexRadioDefault2">
                                                <label class="form-check-label" for="flexRadioDefault2">Public</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="sector" id="flexRadioDefault2">
                                                <label class="form-check-label" for="flexRadioDefault2">Private</label>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <B> <label class="form-label">Cycle</label> </B>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" name="cycle" id="flexCheckDefault">
                                                <label class="form-check-label" for="flexCheckDefault">First Cycle</label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" name="cycle" id="flexCheckChecked">
                                                <label class="form-check-label" for="flexCheckChecked">Second Cycle</label>
                                            </div>
                                            <br>
                                            <br>
                                        </div>

                                        <div class="row mb-3">
                                            <label for="inputEnterYourName" class="col-sm-3 col-form-label"><B>Total number of Students :</B></label>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="girls" placeholder="Girls">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="boys" placeholder="Boys">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="total" placeholder="Total">
                                            </div>
                                        </div>

                                        <div class="row mb-3">
                                            <label for="inputEnterYourName" class="col-sm-3 col-form-label"><B>Total number of Students :</B></label>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="girls" placeholder="Displaced Student">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="boys" placeholder="Refugees">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="total_student" placeholder="Total">
                                            </div>
                                        </div>

                                        <div class="row mb-3">
                                            <label for="inputEnterYourName" class="col-sm-3 col-form-label"><B> Total number of Staff :</B> </label>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="girls" placeholder="Administrative">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="support" placeholder="Support">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="total_staff" placeholder="Total">
                                            </div>
                                        </div>

                                        <div class="row mb-3">
                                            <label for="inputEnterYourName" class="col-sm-3 col-form-label"><B> Total number of Teachers :</B> </label>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="full-time" placeholder="Full-time">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="part-time" placeholder="Part-time">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" class="form-control" name="total_teachers" placeholder="Total">
                                            </div>
                                        </div>
                                    </form>

                                    <!-- End of step 1 html -->

                                </div>+
                                <div id="step-2" class="tab-pane" role="tabpanel" aria-labelledby="step-2">
                                    <h3>Step 2 Content</h3>
                                    <div>

                                        <form action="">
                                            <div class="card">
                                                <div class="card-body">
                                                    <table class="table table-bordered mb-0">
                                                        <thead>
                                                        <tr>
                                                            <th scope="col" rowspan="2">N°</th>
                                                            <th scope="col" rowspan="2" colspan="2">Things to control</th>
                                                            <th scope="col" colspan="2">Existing </th>
                                                            <th scope="col" colspan="2">Functioning handling/Mangement</th>
                                                            <th scope="col" rowspan="2">Remark (Quantitative assessment, others)</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" >YES</th>
                                                            <th scope="col">NO</th>
                                                            <th scope="col">GOOD</th>
                                                            <th scope="col">BAD</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">AT THE LEVEL OF THE PRINCIPAL</th>
                                                        </tr>

                                                        </thead>
                                                        <tbody>
                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Student Registered</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Back-to-school General Assembly</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="3">3</th>
                                                            <td rowspan="3">Composition of the various Councils</td>
                                                            <td >School Management Board</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td >School Management Board</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td >School Management Board</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Complication of Regulatory texts</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">School Clubs</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">6</th>
                                                            <td colspan="2">School reports</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">7</th>
                                                            <td colspan="2">Action plan</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">8</th>
                                                            <td colspan="2">Correspondence registers (Outgoing, Incoming, Internal)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="9">9</th>
                                                            <td colspan="2">Staff room</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Classrooms</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Libraries</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Laboratories</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Infirmary</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Multimedia Resource Centre</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Computer rooms</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Office for guidance and counselling</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">Workshops</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">10</th>
                                                            <td colspan="2">List of class masters</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">11</th>
                                                            <td colspan="2">List of class heads</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">12</th>
                                                            <td colspan="2">Circular N°. 20/23/MINESEC/SG/CELSUI of 22/08/23 bearing
                                                                <br>instructions on the conduct of the 2023-2024 school year</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">13</th>
                                                            <td colspan="2">Structure of the school</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">14</th>
                                                            <td colspan="2">Calendar of activities for the 1st term 2023/2024</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">15</th>
                                                            <td colspan="2">List of teachers absent</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">16</th>
                                                            <td colspan="2">List of Heads of departments</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">17</th>
                                                            <td colspan="2">staffing requirements</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">18</th>
                                                            <td colspan="2">Standing committee for the recruitment of new students and minutes of proceedings</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">19</th>
                                                            <td colspan="2">School projects</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">20</th>
                                                            <td colspan="2">Action plans and other activity reports</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">21</th>
                                                            <td colspan="2">End of 2022/2023 school year report</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">22</th>
                                                            <td colspan="2">End of year School Council Report</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">23</th>
                                                            <td colspan="2">Recruitment file register</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">24</th>
                                                            <td colspan="2">2022/2023 PTA end-of-year report</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">25</th>
                                                            <td colspan="2">Record of resumption / Assumption of services</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">26</th>
                                                            <td colspan="2">Internal regulations</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">27</th>
                                                            <td colspan="2">2022/2023 Administrative Account</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">AT THE LEVEL OF SENIOR DISCIPLINE MASTER</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Roll Call Registers</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Teacher attendance sheet</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <th scope="row">3</th>
                                                            <td colspan="2">Student absence summary sheet</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Duty roster for discipline masters</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">Management of free periods</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">6</th>
                                                            <td colspan="2">Student movements (entry and exit tickets)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">7</th>
                                                            <td colspan="2">Documents on student sanctions</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">AT THE LEVEL OF PEDAGOGY</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="3">1</th>
                                                            <td colspan="2">Do your teacher produce digital resources?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-do-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-do-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-do-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-do-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">If so how?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifso-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifso-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifso-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifso-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">If not, why not?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifnot-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifnot-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifnot-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-ifnot-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="3">2</th>
                                                            <td colspan="2">Are Distance Education resources used in your school?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">If yes, how?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2">If no, why not?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="3">3</th>
                                                            <td colspan="2">Have you acquired equipment to digitalise teaching?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">If so, do they contribute to the effective development of Distance Education activities?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2">If no, why not?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Timetables(Genera,Teachers, by class)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">Teaching syllabuses</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">6</th>
                                                            <td colspan="2">Teacher's record books(circulation, weekly visa)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">7</th>
                                                            <td colspan="2">Teacher's feedback and monitoring notebooks</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">8</th>
                                                            <td colspan="2">Progress sheets by subject</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">9</th>
                                                            <td colspan="2">Correspondences books</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">10</th>
                                                            <td colspan="2">Management of distance learning</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">11</th>
                                                            <td colspan="2">Number of teaching hours for each official</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">12</th>
                                                            <td colspan="2">List of students by level</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">13</th>
                                                            <td colspan="2">Deployment of staff</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">14</th>
                                                            <td colspan="2">Circular letter No. 03/23/LC/MINESEC/SG/IGE/ICG-STT/DRFM/DESTP/DPPC/DAJ
                                                                <br>of 28 March 2023 on the terms and conditions for financing the implementation of
                                                                <br>the Memorandum of Understanding between the Ministry of Secondary Education and iPLANS SA</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">15</th>
                                                            <td colspan="2">In-service training for teachers</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="3">16</th>
                                                            <td colspan="2">Work placement for students</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">If yes, how?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td colspan="2">If not, why not?</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">AT THE LEVEL OF HEADS OF DEPARTEMENT</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Teaching syllabuses</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Calendar of pedagogic workshops</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">3</th>
                                                            <td colspan="2">scheme of work for each teacher in the department  </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Report of the 1st teaching councils</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">coverage rate of lessons and programmes to date</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">AT TEACHER LEVEL</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Teaching syllabuses</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Schemes of work</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">3</th>
                                                            <td colspan="2">Use of teachers' record books </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Lesson preparation sheets</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">Use of iPLANS management software packages</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">AT THE LEVEL OF HEALTH</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Overall cleanliness of the school</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Latrines and their cleanliness</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">3</th>
                                                            <td colspan="2">Condition of blackboards in classrooms </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Implementation of hygiene measures (hand-washing facilities, soap, disinfectants, water points, etc.)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">State of cleanliness of toilets </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">6</th>
                                                            <td colspan="2">Marking of toilets according to gender (girls/boys)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">7</th>
                                                            <td colspan="2">Refuse bins and/or incineration pits </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">8</th>
                                                            <td colspan="2">Canteens and their cleanliness</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">9</th>
                                                            <td colspan="2">Status of canteen operators (records, uniforms, etc.)</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">10</th>
                                                            <td colspan="2">Infirmaries or first-aid kits </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">11</th>
                                                            <td colspan="2">Educational messages displayed on the school premises</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">12</th>
                                                            <td colspan="2">Proximity of bars and gaming rooms</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">13</th>
                                                            <td colspan="2">Green areas</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">SECURITY LEVEL</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Surveillance cameras</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Metal detectors</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">3</th>
                                                            <td colspan="2">Presence of security guards </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">4</th>
                                                            <td colspan="2">Fence</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th scope="col" colspan="8" class="text-center">FINANCIAL LEVEL</th>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">1</th>
                                                            <td colspan="2">Electronic payment of fees</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">2</th>
                                                            <td colspan="2">Sale of school uniforms, books, exercise books and other materials within the school</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">3</th>
                                                            <td colspan="2">Adoption of the school budget by the School Management Board (minutes of the
                                                                <br>Board and signature of the Chair of the SMB) /Provisional budget for 2023/2024 adopted
                                                                <br>git by the School Management Board</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row" rowspan="2">4</th>
                                                            <td rowspan="2">Payment of contributions and examination fees by electronic means</td>
                                                            <td >2022/2023 School year </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td >2023/2024 School year </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-stud-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">5</th>
                                                            <td colspan="2">2022/2023 management account and proof of expenditure </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <th scope="row">6</th>
                                                            <td colspan="2">Funds of the PTA secured in an approved financial institution.</td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <th scope="row">7</th>
                                                            <td colspan="2">Progressive payment of user fees for iPLANS software packages for the last school year </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func">
                                                            </td>
                                                            <td>
                                                                <input class="form-check-input" type="radio" name="rad-are-func" >
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control" name="full-time" placeholder="Remark">
                                                            </td>
                                                        </tr>


                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div id="step-3" class="tab-pane" role="tabpanel" aria-labelledby="step-3">

                                    <form action="">
                                        <div class="card-title d-flex align-items-center">
                                            <div><i class="bx bxs-user me-1 font-22 text-primary"></i>
                                            </div>
                                            <h5 class="mb-0 text-primary"> CP1 FORM </h5>
                                        </div>

                                        <H4 class="text-center">IT PROJECT INFORMATION SHEET</H4>

                                        <div class="row mb-3">
                                            <label for="inputEnterYourName" class="col-sm-3 col-form-label"><B>Total number of Students :</B></label>
                                            <div class="col-sm-3">
                                            </div>
                                            <div class="col-sm-3">
                                                <label for="">Public</label>
                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                            </div>
                                            <div class="col-sm-3">
                                                <label for="">Private</label>
                                                <input class="form-check-input" type="radio" name="rad-are-exist" >
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label"><B>GENERAL INFORMATION</B></label>
                                        </div>

                                        <div class="col-md-6">
                                            <B> <label for="inputPassword" class="form-label">School</label></B>

                                            <select class="form-select mb-3" aria-label="Default select example">
                                                <option selected>GBHS Yaounde</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>

                                        </div>
                                        <div class="col-md-6">
                                            <B>  <label for="inputEmail" class="form-label"><?php echo e(__("messages.region")); ?></label> </B>

                                            <select class="form-select mb-3" aria-label="Default select example" name="division" >
                                                <option selected>Centre</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>
                                        </div>

                                        <div class="col-md-6">
                                            <B> <label for="inputPassword" class="form-label">Division</label></B>

                                            <select class="form-select mb-3" aria-label="Default select example">
                                                <option selected>GBHS Yaounde</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>

                                        </div>
                                        <div class="col-md-6">
                                            <B>  <label for="inputEmail" class="form-label">Sub-Division</label> </B>

                                            <select class="form-select mb-3" aria-label="Default select example" name="division" >
                                                <option selected>Centre</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>
                                        </div>

                                        <div class="col-md-6">
                                            <B> <label class="form-label">Name of principal</label></B>
                                            <input type="text" name="name_of_school" class="form-control" id="inputFirstName">
                                        </div>
                                        <div class="col-md-6">
                                            <B> <label for="inputLastName" class="form-label">Contact</label></B>
                                            <input type="text" name="school_code" class="form-control" id="inputLastName">
                                        </div>

                                        <div class="card">
                                            <div class="card-body">
                                                <div class="col-md-12">
                                                    <label class="form-label"><B>Table 1: Student-to-Computer Ratio</B></label>
                                                </div>
                                                <table class="table table-bordered mb-0">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col">Number (1)</th>
                                                        <th scope="col">Number of functional computers. (2)</th>
                                                        <th scope="col">Student-to-computer ratio (1)/(2)</th>
                                                        <th scope="col">Number of computer rooms</th>
                                                        <th scope="col">Category (Cat A / Cat B)</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <br>

                                                <div class="col-md-12">
                                                    <label class="form-label"><B>Table 2: Characteristics of IT technologies and resources for administrative staff</B></label>
                                                </div>
                                                <table class="table table-bordered mb-0">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col" colspan="3">Technology</th>
                                                        <th scope="col" colspan="2">LMS1</th>
                                                        <th scope="col" colspan="6">Number available</th>
                                                    </tr>
                                                    <tr>
                                                        <th scope="col">LAN desktop</th>
                                                        <th scope="col">Stand alone</th>
                                                        <th scope="col">Internet Connection</th>
                                                        <th scope="col">iPlans</th>
                                                        <th scope="col">Others</th>
                                                        <th scope="col">Computers</th>
                                                        <th scope="col">Printers</th>
                                                        <th scope="col">Photocopier(s)</th>
                                                        <th scope="col">Scanners</th>
                                                        <th scope="col">Others</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <br>

                                                <div class="col-md-12">
                                                    <label class="form-label"><B>Table 3: Characteristics of IT technologies and resources for teaching</B></label>
                                                </div>
                                                <table class="table table-bordered mb-0">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col" colspan="4">Technology</th>
                                                        <th scope="col" colspan="6">Number available</th>
                                                    </tr>
                                                    <tr>
                                                        <th scope="col">N-Computing</th>
                                                        <th scope="col">LAN desktop</th>
                                                        <th scope="col">Stand alone</th>
                                                        <th scope="col">Internet Connection</th>
                                                        <th scope="col">Computers</th>
                                                        <th scope="col">Tablets</th>
                                                        <th scope="col">Printers</th>
                                                        <th scope="col">Projectors</th>
                                                        <th scope="col">Scanners</th>
                                                        <th scope="col">Others</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>

                                                <br><br>

                                                <H5 class="text-center">IT PROJECT FOR THE 2023 / 2024 SCHOOL YEAR</H5>

                                                <div class="col-md-12">
                                                    <label class="form-label"><B>Table 5: Proposed IT project for the next two years</B></label>
                                                </div>
                                                <table class="table table-bordered mb-0">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col"></th>
                                                        <th scope="col">Design and layout of room</th>
                                                        <th scope="col">Purchasing & Installation</th>
                                                        <th scope="col">Maintenance</th>
                                                        <th scope="col">Consumables</th>
                                                        <th scope="col">Seminars & Conferences</th>
                                                        <th scope="col">Part-time teachers' Salaries</th>
                                                        <th scope="col">Category (CAT A/B)</th>
                                                        <th scope="col">Model (SMax, DInc)</th>
                                                        <th scope="col">Ratio (student / computer)</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td>(V)</td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <br>

                                                <div class="col-md-12">
                                                    <label class="form-label"><B>Table 6: Characteristics of IT technologies and resources planned for the current year</B></label>
                                                </div>
                                                <table class="table table-bordered mb-0">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col" colspan="7">Technology</th>
                                                        <th scope="col" colspan="6">Number available</th>
                                                    </tr>
                                                    <tr>
                                                        <th scope="col">N-Computing</th>
                                                        <th scope="col">LAN desktop</th>
                                                        <th scope="col">Stand alone</th>
                                                        <th scope="col">Internet Connection</th>
                                                        <th scope="col">Video surveillance</th>
                                                        <th scope="col">Solar Kit</th>
                                                        <th scope="col">Generators</th>
                                                        <th scope="col">Computers</th>
                                                        <th scope="col">Tablets</th>
                                                        <th scope="col">Printers</th>
                                                        <th scope="col">Projectors</th>
                                                        <th scope="col">Scanners</th>
                                                        <th scope="col">Others</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <br><br>

                                                <H5 class="text-center">PROJECTION FOR THE NEXT TWO YEARS</H5>

                                                <div class="col-md-12">
                                                    <label class="form-label"><B>Table 7: Proposed IT project for the next two years</B></label>
                                                </div>
                                                <table class="table table-bordered mb-0">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col">School year</th>
                                                        <th scope="col">Number of computers</th>
                                                        <th scope="col">Possible funding source(s)</th>
                                                        <th scope="col">Estimated budget</th>
                                                        <th scope="col">Number of students per computer</th>
                                                        <th scope="col">Remarks</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr>
                                                        <td>20..../20....</td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    <tr>
                                                        <td>20..../20....</td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                        <td><input type="text" class="form-control" name="full-time"></td>
                                                    </tr>
                                                    </tbody>
                                                </table>

                                                <br>

                                                <div class="col-12">
                                                    <label for="inputAddress" class="form-label"><b>General Remarks</b></label>
                                                    <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="3"></textarea>
                                                </div>


                                            </div>

                                            <hr>


                                        </div>
                                    </form>

                                </div>
                                <div id="step-4" class="tab-pane" role="tabpanel" aria-labelledby="step-4">

                                    <H5 class="text-center">IDENTIFICATION OF KEY PROBLEMS ENCOUNTERED AND COLLECTION OF COMPLAINTS</H5>

                                    <h5 class="mb-0 text-primary"> A- Identify the main problems encountered in the school </h5>
                                    <br>

                                    <form action="">
                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>At the administrative level</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                        <br>

                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>At the pedagogic level</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                        <br>

                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>At the health level</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                        <br>

                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>At the security level</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                        <br>

                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>At the financial level</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                        <br>

                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>A- Identify grievances relating to the above-mentioned aspects, for submission to hierachy</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                        <br>

                                        <div class="col-12">
                                            <label for="inputAddress" class="form-label"><b>V- GENERAL OBSERVATION</b></label>
                                            <textarea class="form-control" id="inputAddress" placeholder="Remarks..." rows="5"></textarea>
                                        </div>
                                    </form>
                                    <br>

                                </div>
                            </div>
                        </div>

                        <!-- End SmartWizard html -->

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if ($__env->exists('layouts.default.footer')) echo $__env->make('layouts.default.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<!--end wrapper-->
<!-- Bootstrap JS -->
<script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
<!--plugins-->
<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
<!--Password show & hide js -->
<script>
    $(document).ready(function () {
        $("#show_hide_password a").on('click', function (event) {
            event.preventDefault();
            if ($('#show_hide_password input').attr("type") == "text") {
                $('#show_hide_password input').attr('type', 'password');
                $('#show_hide_password i').addClass("bx-hide");
                $('#show_hide_password i').removeClass("bx-show");
            } else if ($('#show_hide_password input').attr("type") == "password") {
                $('#show_hide_password input').attr('type', 'text');
                $('#show_hide_password i').removeClass("bx-hide");
                $('#show_hide_password i').addClass("bx-show");
            }
        });
    });
</script>
<!--app JS-->
<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>

    <script src="assets/plugins/smart-wizard/js/jquery.smartWizard.min.js"></script>
    <script>
        $(document).ready(function () {
            // Toolbar extra buttons
            var btnFinish = $('<button></button>').text('Finish').addClass('btn btn-info').on('click', function () {
                alert('Finish Clicked');
            });
            var btnCancel = $('<button></button>').text('Cancel').addClass('btn btn-danger').on('click', function () {
                $('#smartwizard').smartWizard("reset");
            });
            // Step show event
            $("#smartwizard").on("showStep", function (e, anchorObject, stepNumber, stepDirection, stepPosition) {
                $("#prev-btn").removeClass('disabled');
                $("#next-btn").removeClass('disabled');
                if (stepPosition === 'first') {
                    $("#prev-btn").addClass('disabled');
                } else if (stepPosition === 'last') {
                    $("#next-btn").addClass('disabled');
                } else {
                    $("#prev-btn").removeClass('disabled');
                    $("#next-btn").removeClass('disabled');
                }
            });
            // Smart Wizard
            $('#smartwizard').smartWizard({
                selected: 0,
                theme: 'dots',
                transition: {
                    animation: 'slide-horizontal', // Effect on navigation, none/fade/slide-horizontal/slide-vertical/slide-swing
                },
                toolbarSettings: {
                    toolbarExtraButtons: [btnFinish, btnCancel]
                }
            });
        });
    </script>

</body>

</html>
<?php /**PATH /home/minesec/public_html/dev.minesec.online/resources/views/progression_sheet.blade.php ENDPATH**/ ?>