<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!--favicon-->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.png')); ?>" type="image/png" />

    <!--plugins-->
    <link href="<?php echo e(asset('assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />

    <!-- loader-->
    <link href="<?php echo e(asset('assets/css/pace.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('assets/js/pace.min.js')); ?>"></script>

    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet">
    <title><?php echo e(__(config('app.name'))); ?></title>

    <link href="<?php echo e(asset('assets/plugins/smart-wizard/css/smart_wizard_all.min.css')); ?>" rel="stylesheet" type="text/css" />

    <link href="<?php echo e(asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/select2/css/select2-bootstrap4.css')); ?>" rel="stylesheet" />
    <style>
        .eighty{
            height: 50vh;
        }
        .eighty-added{
            height: 70vh;
        }
    </style>


</head>

<body class="bg-login">
<!--wrapper-->
<div class="wrapper">
    <?php if ($__env->exists('layouts.default.header')) echo $__env->make('layouts.default.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-10 mx-auto">
                <h6 class="mb-0 text-uppercase">Collection Form</h6>
                <hr/>
                <div class="card border-top border-0 border-4 border-primary">
                    <div class="card-body p-5">

                        <div class="card-title d-flex align-items-center">
                            <div><i class="bx bxs-user me-1 font-22 text-primary"></i>
                            </div>
                            <h5 class="mb-0 text-primary"><?php echo e(__("messages.data_collection")); ?></h5>
                        </div>
                        <hr>

                        <div id="smartwizard">
                            <ul class="nav">
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-1">	<strong><?php echo e(__("messages.step")); ?> 1</strong><br><?php echo e(__("messages.general_information")); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-2">	<strong><?php echo e(__("messages.step")); ?> 2</strong><br><?php echo e(__("messages.total_program_coverage")); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-3">	<strong><?php echo e(__("messages.step")); ?> 3</strong><br><?php echo e(__("messages.presence")); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-4">	<strong><?php echo e(__("messages.step")); ?> 4</strong><br><?php echo e(__("messages.digitalisation")); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-5">	<strong><?php echo e(__("messages.step")); ?> 5</strong><br><?php echo e(__("messages.ots")); ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#step-6">	<strong><?php echo e(__("messages.step")); ?> 6</strong><br><?php echo e(__("messages.training_activities")); ?></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <form class="needs-validation" novalidate id="data_collection" method="post">

                                    <div id="step-1" class="tab-pane eighty" role="tabpanel" aria-labelledby="step-1">

                                            <div class="row">
                                                <div class="col-md-4 p-3">
                                                    <B> <label for="sub_system_id" class="form-label"><?php echo e(__("messages.sub_systems")); ?></label> </B>
                                                    <select class="form-select" id="sub_system_id" name="sub_system_id" required >
                                                        <option value=""><?php echo e(__("messages.select")); ?></option>
                                                        <?php $__currentLoopData = $subSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSystem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($subSystem->{"id"}); ?>"><?php echo e($subSystem->{"designation"}); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B><label for="education_type_id" class="form-label"><?php echo e(__("messages.education_type")); ?></label></B>
                                                    <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3" id="subEducationTypeInput">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.sub_education_type")); ?></label></B>
                                                    <select class="form-select" id="sub_education_type_id" name="sub_education_type_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3" id="specialtyInput">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.specialty")); ?></label></B>
                                                    <select class="form-select" id="specialty_id" name="specialty_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3" id="levelInput">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.level")); ?></label></B>
                                                    <select class="form-select" id="level_id" name="level_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3" id="specialtyClassInput">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label></B>
                                                    <select class="form-select" id="specialty_class_id" name="specialty_class_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3" id="levelClassInput">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label></B>
                                                    <select class="form-select" id="level_class_id" name="level_class_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3" id="classInput">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label></B>
                                                    <select class="form-select" id="class_id" name="class_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B><label for="validationTooltip01" class="form-label"><?php echo e(__("messages.subject")); ?></label></B>
                                                    <select class="form-select" id="subject_id" name="subject_id" required aria-label="select example">
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <br/>
                                                <div class="row">
                                                    <div class="col-md-4 p-3">
                                                        <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.inspector_name")); ?></label></B>
                                                        <input type="text" name="inspector_name" class="form-control" id="inspector_name">
                                                        <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                    </div>

                                                    <div class="col-md-6 p-3">
                                                        <B> <label class="form-label"><?php echo e(__("messages.name_of_school")); ?> </label></B>
                                                        <input type="text" name="name_of_school" class="form-control" id="inputFirstName">
                                                        <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                    </div>
                                                </div>

                                            </div>
                                    </div>

                                    <div id="step-2" class="tab-pane eighty" role="tabpanel" aria-labelledby="step-2">
                                            <div class="row">
                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.lessons_programmed")); ?></label></B>
                                                    <input type="number" name="number_of_lessons_programmed" class="form-control" id="number_of_lessons_programmed">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.lessons_done")); ?></label></B>
                                                    <input type="number" name="number_of_lessons_done" class="form-control" id="number_of_lessons_done">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.percentage")); ?></label></B>
                                                    <input type="text" name="percentage_number_of_lessons_done" class="form-control" id="percentage_number_of_lessons_done" readonly value="100%">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-6 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.comment")); ?></label></B>
                                                    <textarea name="comment_number_of_lessons_done" class="form-control" id="comment_number_of_lessons_done"></textarea>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>
                                            </div>
                                    </div>

                                    <div id="step-3" class="tab-pane eighty" role="tabpanel" aria-labelledby="step-3">
                                            <div class="row">
                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.total_teaching_hours")); ?></label></B>
                                                    <input type="number" name="number_of_teaching_hours" class="form-control" id="number_of_teaching_hours">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.lessons_taught")); ?></label></B>
                                                    <input type="number" name="number_of_hours_taught" class="form-control" id="number_of_hours_taught">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.percentage")); ?></label></B>
                                                    <input type="text" name="percentage_number_of_hours_taught" class="form-control" id="percentage_number_of_hours_taught" readonly value="100%">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-6 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.comment")); ?></label></B>
                                                    <textarea name="comment_number_of_hours_taught" class="form-control" id="comment_number_of_hours_taught"></textarea>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>
                                            </div>
                                    </div>

                                    <div id="step-4" class="tab-pane eighty-added" role="tabpanel" aria-labelledby="step-4">
                                            <div class="row">
                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.total_digitalised_lessons")); ?></label></B>
                                                    <input type="number" name="number_of_lessons_to_digitalised" class="form-control" id="number_of_lessons_to_digitalised">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.number_digitalised")); ?></label></B>
                                                    <input type="number" name="number_of_lessons_digitalised" class="form-control" id="number_of_lessons_digitalised">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.percentage")); ?></label></B>
                                                    <input type="text" name="percentage_number_of_lessons_digitalised" class="form-control" id="percentage_number_of_lessons_digitalised" readonly value="100%">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.title_digitalised_lessons")); ?></label></B>
                                                    <div class="col-xl-12 col-md-12">
                                                        <div class="row">
                                                            <div class="col-xl-6"><?php echo e(__("messages.add")); ?></div>
                                                            <div class="col-xl-6"><button type="button" onclick="add_title()" class="btn btn-secondary btn-sm"><i class="bx bx-plus"></i></button></div>
                                                        </div>
                                                        <div class="col-xl-12">
                                                            <table class="table3" id="tableID">
                                                                <tr id="row0">
                                                                    <td><input type="text" class="form-control" id="titles_of_digitalised_lessons" name="titles_of_digitalised_lessons[]" ></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B>  <label for="inputEmail" class="form-label"><?php echo e(__("messages.digitisation_types")); ?></label> </B>
                                                    <select class="form-select multiple-select" id="digitisation_types" name="digitisation_types[]" multiple="multiple">
                                                        <option disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                        <?php $__currentLoopData = $digitisationTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B>  <label for="inputEmail" class="form-label"><?php echo e(__("messages.digitisation_tools_used")); ?></label> </B>
                                                    <select class="form-select multiple-select" id="digitisation_tools_used" name="digitisation_tools_used[]" multiple="multiple">
                                                        <option disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                        <?php $__currentLoopData = $digitisationToolsUsed; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B><label for="inputLastName" class="form-label"><?php echo e(__("messages.comment")); ?></label></B>
                                                    <textarea name="comment_number_of_lessons_digitalised" class="form-control" id="comment_number_of_lessons_digitalised"></textarea>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>
                                            </div>
                                    </div>

                                    <div id="step-5" class="tab-pane eighty" role="tabpanel" aria-labelledby="step-5">
                                            <div class="row">
                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.ots_effective")); ?></label></B> <br/>
                                                    <input type="radio" name="ots_effective" id="ots_effective1" value="yes">
                                                    <label for="contactChoice1">Yes</label>

                                                    <input type="radio" name="ots_effective" id="ots_effective2" value="no" />
                                                    <label for="contactChoice2">No</label>
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.teachers_stopped")); ?></label></B>
                                                    <input type="number" name="number_of_ots_participants" class="form-control" id="number_of_ots_participants">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.measures_taken_coverage")); ?></label></B>
                                                    <div class="col-xl-12 col-md-12">
                                                        <div class="row">
                                                            <div class="col-xl-6"><?php echo e(__("messages.add")); ?></div>
                                                            <div class="col-xl-6"><button type="button" onclick="add_ots_measures()" class="btn btn-secondary btn-sm"><i class="bx bx-plus"></i></button>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-12">
                                                            <table class="table3" id="tableID2">
                                                                <tr id="ots_row0">
                                                                    <td><input type="text" id="measures_taken_to_ensure_program_coverage" name="measures_taken_to_ensure_program_coverage[]" class="form-control"></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>

                                    <div id="step-6" class="tab-pane eighty" role="tabpanel" aria-labelledby="step-6">
                                            <div class="row">
                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.number_seminar_organised")); ?></label></B>
                                                    <input type="number" name="number_of_seminars_organised" class="form-control" id="number_of_seminars_organised">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="inputLastName" class="form-label"><?php echo e(__("messages.number_teachers_present")); ?></label></B>
                                                    <input type="number" name="number_of_seminar_participants" class="form-control" id="number_of_seminar_participants">
                                                    <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                                </div>

                                                <div class="col-md-4 p-3">
                                                    <B> <label for="topics_discussed" class="form-label"><?php echo e(__("messages.topics_discussed")); ?></label></B>
                                                    <div class="col-xl-12 col-md-12">
                                                        <div class="row">
                                                            <div class="col-xl-6"><?php echo e(__("messages.add")); ?></div>
                                                            <div class="col-xl-6"><button type="button" onclick="add_topics()" class="btn btn-secondary btn-sm"><i class="bx bx-plus"></i></button>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-12">
                                                            <table class="table3" id="tableID3">
                                                                <tr id="topic_row0">
                                                                    <td><input type="text" id="seminar_topics_discussed" name="seminar_topics_discussed[]" class="form-control"></td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
    <?php if ($__env->exists('layouts.default.footer')) echo $__env->make('layouts.default.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<!--end wrapper-->
<!-- Bootstrap JS -->
<script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
<!--plugins-->
<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>

<!--app JS-->
<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/smart-wizard/js/jquery.smartWizard.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>



    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

    $(document).ready(function () {
        // Toolbar extra buttons
        var btnFinish = $('<button type="submit"></button>').text('Save').addClass('btn btn-info').on('click', function () {

            var form = document.getElementById('data_collection');
            var formData = new FormData(form);
                $.ajax({
                    url: "<?php echo e(route("data-collection")); ?>",
                    method: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (response) {
                        alert('Your form has been sent successfully.');
                    },
                    error: function (xhr, status, error) {
                        alert('Your form was not sent successfully.');
                        console.error(error);
                    }
                });

        // var forms = document.querySelectorAll('.needs-validation')
        //     var data = document.getElementById('data_collection');
        //
        //     var sub_system_id = $("#sub_system_id").val();
        //     var education_type_id = $("#education_type_id").val();
        //     var sub_education_type_id = $("#sub_education_type_id").val();
        //     var specialty_id = $("#specialty_id").val();
        //     var level_id = $("#level_id").val();
        //     var specialty_class_id = $("#specialty_class_id").val();
        //     var level_class_id = $("#level_class_id").val();
        //     var class_id = $("#class_id").val();
        //     var subject_id = $("#subject_id").val();
        //     var inspector_name = $("#inspector_name").val();
        //     var name_of_school = $("#name_of_school").val();
        //
        //     var sub_system_id = $("#sub_system_id").val();
        //     var sub_system_id = $("#sub_system_id").val();
        //     var sub_system_id = $("#sub_system_id").val();
        //     var sub_system_id = $("#sub_system_id").val();

        });

        var btnCancel = $('<button></button>').text('Cancel').addClass('btn btn-danger').on('click', function () {
            $('#smartwizard').smartWizard("reset");
        });

        // Step show event
        $("#smartwizard").on("showStep", function (e, anchorObject, stepNumber, stepDirection, stepPosition) {
            $("#prev-btn").removeClass('disabled');
            $("#next-btn").removeClass('disabled');

            if (stepPosition === 'first') {
                $("#prev-btn").addClass('disabled');
            } else if (stepPosition === 'last') {
                $("#next-btn").addClass('disabled');
            } else {
                $("#prev-btn").removeClass('disabled');
                $("#next-btn").removeClass('disabled');
            }
        });

        // Smart Wizard
        $('#smartwizard').smartWizard({
            selected: 0,
            theme: 'dots',
            transition: {
                animation: 'slide-horizontal', // Effect on navigation, none/fade/slide-horizontal/slide-vertical/slide-swing
            },
            toolbarSettings: {
                toolbarExtraButtons: [btnFinish, btnCancel]
            }
        });
    });

    $('#classInput').css('display', 'none'); // Hide the text input box in default
    $('#subEducationTypeInput').css('display', 'none'); // Hide the text input box in default
    $('#specialtyInput').css('display', 'none'); // Hide the text input box in default
    $('#specialtyClassInput').css('display', 'none'); // Hide the text input box in default
    $('#levelInput').css('display', 'none'); // Hide the text input box in default
    $('#levelClassInput').css('display', 'none'); // Hide the text input box in default
    $('#other').css('display', 'none'); // Hide the text input box in default

    // when sub system dropdown changes
    $('#sub_system_id').change(function() {
        var subSystemId = $(this).val();
        if (subSystemId) {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.education-type.get')); ?>?sub_system_id=" + subSystemId,
                success: function(data) {
                    if (data) {
                        $("#education_type_id").empty();
                        $("#education_type_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(data, function(key, value) {
                            var sel = "";
                            if (education_type_id === value.id) {
                                sel = "selected";
                            }
                            $("#education_type_id").append('<option value="' + value.id + value.type +' ">' + value.designation +'</option>');
                        });
                    } else {
                        $("#education_type_id").empty();
                    }
                }
            });

            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.subject.get-sub-system-subjects')); ?>?sub_system_id=" + subSystemId,
                success: function(data) {
                    if (data) {
                        $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(data, function (key, value)
                        {
                            $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    }
                }
            });
        } else {
            $("#education_type_id").empty();
            $("#class_id").empty();
        }
    });

    // when education type dropdown changes
    $('#education_type_id').on('change', function() {
        var educationTypeId = $(this).val();
        function processInput(educationTypeId) {
            var output = [];
            var json = educationTypeId.split(' '); // Split text by spaces into array

            json.forEach(function (item) { // Loop through each array item
                var out = item.replace(/\'/g,''); // Remove all single quote '  from chunk
                out = out.split(/(\d+)/); // Now again split the chunk by Digits into array
                out = out.filter(Boolean); // With Boolean we can filter out False Boolean Values like -> false, null, 0
                output.push(out);
            });

            return output;
        }

        var outputId = processInput(educationTypeId[0]);
        var outputType = processInput(educationTypeId[1]);

        if (outputType == "G") {
            var div_data = "";
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.class.get')); ?>?education_type_id=" + outputId,
                success: function(data) {
                    if (data) {
                        $('#classInput').css('display', 'block');
                        $('#subEducationTypeInput').css('display', 'none');
                        $('#specialtyInput').css('display', 'none');
                        $('#specialtyClassInput').css('display', 'none');
                        $('#levelInput').css('display', 'none');
                        $('#levelClassInput').css('display', 'none');

                        $("#class_id").empty();
                        $("#class_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(data, function(key, value) {
                            $("#class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    } else {
                        $("#class_id").empty();
                    }
                }
            });
        } else {
            $("#class_id").empty();
        }

        if (outputType == "T") {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.sub-education-type.get')); ?>?education_type_id=" + outputId,
                success: function(res) {
                    if (res) {
                        $('#classInput').css('display', 'none');
                        $('#levelInput').css('display', 'none');
                        $('#levelClassInput').css('display', 'none');
                        $('#subEducationTypeInput').css('display', 'block');
                        $('#specialtyInput').css('display', 'block');
                        $('#specialtyClassInput').css('display', 'block');

                        $("#sub_education_type_id").empty();
                        $("#sub_education_type_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(res, function(key, value) {
                            $("#sub_education_type_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    } else {
                        $("#sub_education_type_id").empty();
                    }
                }
            });
        } else {
            $("#sub_education_type_id").empty();
            $("#specialty_id").empty();
        }

        if (outputType == "E") {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.levels.get')); ?>?education_type_id=" + outputId,
                success: function(res) {
                    if (res) {
                        $('#classInput').css('display', 'none');
                        $('#subEducationTypeInput').css('display', 'none');
                        $('#specialtyInput').css('display', 'none');
                        $('#specialtyClassInput').css('display', 'none');
                        $('#levelInput').css('display', 'block');
                        $('#levelClassInput').css('display', 'block');
                        $("#level_id").empty();
                        $("#level_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(res, function(key, value) {
                            $("#level_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    } else {
                        $("#level_id").empty();
                    }
                }
            });
        } else {
            $("#level_id").empty();
            $("#level_class_id").empty();
        }
    });

    // when sub education type dropdown changes
    $('#sub_education_type_id').on('change', function() {
        var subEducationTypeId = $(this).val();
        if (subEducationTypeId) {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.specialty.get')); ?>?sub_education_type_id=" + subEducationTypeId,
                success: function(res) {
                    if (res) {
                        $("#specialty_id").empty();
                        $("#specialty_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(res, function(key, value) {
                            $("#specialty_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    } else {
                        $("#specialty_id").empty();
                    }
                }
            });
        } else {
            $("#specialty_id").empty();
        }
    });

    $('#specialty_id').on('change', function() {
        var specialtyId = $(this).val();
        if (specialtyId) {
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.class.get-specialty-classes')); ?>?specialty_id=" + specialtyId,
                success: function(data) {
                    var div_data = "";
                    if (data) {
                        $("#specialty_class_id").empty();
                        $("#specialty_class_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(data, function(key, value) {
                            $("#specialty_class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    } else {
                        $("#specialty_class_id").empty();
                    }
                }
            });
        } else {
            $("#specialty_class_id").empty();
        }
    });

    $('#level_id').on('change', function() {
        var levelId = $(this).val();
        if (levelId) {
            var div_data = "";
            $.ajax({
                type: "GET",
                url: "<?php echo e(route('home.level-classes.get')); ?>?level_id=" + levelId,
                success: function(data) {
                    if (data) {
                        $("#level_class_id").empty();
                        $("#level_class_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                        $.each(data, function(key, value) {
                            $("#level_class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                        });
                    } else {
                        $("#level_class_id").empty();
                    }
                }
            });
        } else {
            $("#level_class_id").empty();
        }
    });

    $('.multiple-select').select2({
        theme: 'bootstrap4',
        width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
        placeholder: $(this).data('placeholder'),
        allowClear: Boolean($(this).data('allow-clear')),
    });

    (function () {
        'use strict'

        // Fetch all the forms we want to apply custom Bootstrap validation styles to
        var forms = document.querySelectorAll('.needs-validation')

        // Loop over them and prevent submission
        Array.prototype.slice.call(forms)
            .forEach(function (form) {
                form.addEventListener('submit', function (event) {
                    if (!form.checkValidity()) {
                        event.preventDefault()
                        event.stopPropagation()
                    }
                    form.classList.add('was-validated')
                }, false)
            })
    })()

    function add_title() {
        var table = document.getElementById("tableID");
        var table_len = (table.rows.length);
        var id = parseInt(table_len);
        var row = table.insertRow(table_len).outerHTML = "<tr id='row" + id + "'><td><input type='text' class='form-control' id='titles_of_digitalised_lessons' name='titles_of_digitalised_lessons[]'></td> <td><button type='button' onclick='delete_title(" + id + ")'><i class='text-danger bx bxs-trash ms-3'></i></button></td></tr>";
    }

    function delete_title(id) {
        var table = document.getElementById("tableID");
        var rowCount = table.rows.length;
        $("#row" + id).html("");
        //table.deleteRow(id);
    }

    function add_ots_measures() {
        var table = document.getElementById("tableID2");
        var table_len = (table.rows.length);
        var id = parseInt(table_len);
        var row = table.insertRow(table_len).outerHTML = "<tr id='ots_row" + id + "'><td><input type='text' class='form-control' id='measures_taken_to_ensure_program_coverage' name='measures_taken_to_ensure_program_coverage[]'></td> <td><button type='button' onclick='delete_ots_measures(" + id + ")'><i class='text-danger bx bxs-trash ms-3'></i></button></td></tr>";
    }

    function delete_ots_measures(id) {
        var table = document.getElementById("tableID2");
        var rowCount = table.rows.length;
        $("#ots_row" + id).html("");
        //table.deleteRow(id);
    }

    function add_topics() {
        var table = document.getElementById("tableID3");
        var table_len = (table.rows.length);
        var id = parseInt(table_len);
        var row = table.insertRow(table_len).outerHTML = "<tr id='topic_row" + id + "'><td><input type='text' class='form-control' id='seminar_topics_discussed' name='seminar_topics_discussed[]'></td> <td><button type='button' onclick='delete_topics(" + id + ")'><i class='text-danger bx bxs-trash ms-3'></i></button></td></tr>";
    }

    function delete_topics(id) {
        var table = document.getElementById("tableID3");
        var rowCount = table.rows.length;
        $("#topic_row" + id).html("");
        //table.deleteRow(id);
    }

</script>

<script src="<?php echo e(asset('https://unpkg.com/feather-icons')); ?>"></script>
<script>
    feather.replace()
</script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\minesec-distance-education-web\resources\views/data_collection.blade.php ENDPATH**/ ?>