<?php $__env->startSection('title', sprintf('%s - %s', __('messages.subject_lessons'), __(config('app.name')))); ?>

<?php $__env->startSection("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("wrapper"); ?>
    <div class="page-wrapper">
        <div class="page-content">

        <?php echo $__env->make("admin.response.global", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3"><?php echo e(__("messages.add_subject_lesson")); ?></div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">

                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate enctype="multipart/form-data" action="<?php echo e(route("subject.lesson-title.create")); ?>" method="POST">
                                            <?php echo csrf_field(); ?>

                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label"><?php echo e(__("messages.subject_group")); ?></label>
                                                <select class="form-select" id="subject_group_id" name="subject_group_id" required>
                                                    <option selected disabled value=""><?php echo e(__("messages.select")); ?></option>
                                                    <?php $__currentLoopData = $subjectGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subjectGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($subjectGroup->{"id"}); ?>"><?php echo e($subjectGroup->{"designation"}); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label"><?php echo e(__("messages.sub_systems")); ?></label>
                                                <select class="form-select" id="subject_group_sub_system_id" name="subject_group_sub_system_id" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.education_type")); ?></label>
                                                <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="classInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label>
                                                <select class="form-select" id="class_id" name="class_id" aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="subEducationTypeInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.sub_education_type")); ?></label>
                                                <select class="form-select" id="sub_education_type_id" name="sub_education_type_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="specialtyInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.specialty")); ?></label>
                                                <select class="form-select" id="specialty_id" name="specialty_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="specialtyClassInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label>
                                                <select class="form-select" id="specialty_class_id" name="specialty_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="levelInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.level")); ?></label>
                                                <select class="form-select" id="level_id" name="level_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="levelClassInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.class")); ?></label>
                                                <select class="form-select" id="level_class_id" name="level_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="col-md-12" id="subjectInput">
                                                <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.subjects")); ?></label>
                                                <select class="form-select" id="subject_id" name="subject_id" aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback"><?php echo e(__("error.filed_required")); ?></div>
                                            </div>

                                            <div class="card-body">
                                                <div class="form-check form-switch float-end">
                                                    <label class="form-check-label" for="flexSwitchCheckDefault"><?php echo e(__("messages.upload_file")); ?>

                                                        <input class="form-check-input" type="checkbox" name="upload_file" id="showUploadField" value="yes" <?php echo e(old('upload_file') ? 'checked' : null); ?> onchange="switchView()">
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                               <span id="lessonsInput">
                                                 <div class="row gy-3">
                                                        <div class="col-md-4">
                                                            <button type="button" onclick="CreateTodo();" class="btn btn-primary">Add</button>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <label for="validationTooltip01" class="form-label"><?php echo e(__("messages.lesson_title")); ?></label>
                                                            <input id="todo-input" type="text" class="form-control" value="">
                                                        </div>
                                                    </div>
                                                 <div class="form-row mt-3">
                                                        <div class="col-12">
                                                            <div id="todo-container"></div>
                                                        </div>
                                                    </div>
                                               </span>
                                            </div>

                                            <div class="col-md-12">
                                                <span id="fileUpload">
                                                    <input type="file" name="lesson_titles" class="form-control" />
                                                </span>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit"><?php echo e(__("messages.save")); ?></button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(__("messages.subject_group")); ?></th>
                                                <th><?php echo e(__("messages.sub_systems")); ?></th>
                                                <th><?php echo e(__("messages.education_type")); ?></th>
                                                <th><?php echo e(__("messages.class")); ?></th>
                                                <th><?php echo e(__("messages.subject")); ?></th>
                                                <th><?php echo e(__("messages.action")); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $lessonTitles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lessonTitle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo $lessonTitle->{"title"} ?></td>
                                                    <td><?php echo $lessonTitle->{"subSystem"}->{"designation"} ?></td>
                                                    <td><?php echo $lessonTitle->{"educationType"}->{"designation"} ?></td>
                                                    <td><?php echo $lessonTitle->{"classes"}->{"designation"} ?></td>
                                                    <td><?php echo $lessonTitle->{"subject"}->{"designation"} ?></td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="<?php echo e(route("subject.edit-class-subject", $lessonTitle->{"id"})); ?>" class="bx bxs-pencil" title="<?php echo e(__("messages.edit")); ?>"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal" data-lesson_tittle_id="<?php echo e($lessonTitle->{"id"}); ?>" data-lesson_tittle="<?php echo e($lessonTitle->{"title"}); ?>" title="<?php echo e(__("messages.delete")); ?>"></a>
                                                        </div>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <?php echo $__env->make("admin.subject.lesson_titles.delete_modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("script"); ?>
    <script>
        // to do list
        var todos = [{
            text: "",
            done: false,
            id: 0
        }];

        var currentTodo = {
            text: "",
            done: false,
            id: 0
        }

        document.getElementById("todo-input").oninput = function (e) {
            currentTodo.text = e.target.value;
        };

        /*
            //jQuery Version
            $('#todo-input').on('input',function(e){
                currentTodo.text = e.target.value;
               });
            */

        function DrawTodo(todo) {
            var newTodoHTML = `
		<div class="pb-3 todo-item" todo-id="${todo.id}">
			<div class="input-group">

					<div class="input-group-text">
						<input type="checkbox" onchange="TodoChecked(${todo.id})" aria-label="Checkbox for following text input" ${todo.done&& "checked"}>
					</div>

				<input type="text" class="form-control ${todo.done&&" todo-done "}" id="lesson_title_${todo.id}"  name="lesson_titles[]" aria-label="Text input with checkbox" value="${todo.text}">

					<button todo-id="${todo.id}" class="btn btn-outline-secondary bg-danger text-white" type="button" onclick="DeleteTodo(this);" id="button-addon2 ">X</button>

			</div>
		</div>
		  `;
            var dummy = document.createElement("DIV");
            dummy.innerHTML = newTodoHTML;
            document.getElementById("todo-container").appendChild(dummy.children[0]);

            /*
                //jQuery version
                 var newTodo = $.parseHTML(newTodoHTML);
                 $("#todo-container").append(newTodo);
                */
        }

        function RenderAllTodos() {
            var container = document.getElementById("todo-container");
            while (container.firstChild) {
                container.removeChild(container.firstChild);
            }

            /*
                //jQuery version
                  $("todo-container").empty();
                */

            for (var i = 0; i < todos.length; i++) {
                DrawTodo(todos[i]);
            }
        }
        RenderAllTodos();

        function DeleteTodo(button) {
            var deleteID = parseInt(button.getAttribute("todo-id"));
            /*
                //jQuery version
                  var deleteID = parseInt($(button).attr("todo-id"));
                */
            for (let i = 0; i < todos.length; i++) {
                if (todos[i].id === deleteID) {
                    todos.splice(i, 1);
                    RenderAllTodos();
                    break;
                }
            }
        }

        function TodoChecked(id) {
            todos[id].done = !todos[id].done;
            RenderAllTodos();
        }

        function CreateTodo() {
            newtodo = {
                text: currentTodo.text,
                done: false,
                id: todos.length
            }
            todos.push(newtodo);
            clearText()
            RenderAllTodos();
        }

        function clearText()
        {
            document.getElementById('todo-input').value = "";
        }

        $('#fileUpload').css('display', 'none'); // Show the text input box in default
        $('#lessonsInput').css('display', 'block'); // Hide the text input box in default
        function switchView() {
            if ($('#showUploadField').prop('checked')) {
                $('#fileUpload').css('display', 'block');
                $('#lessonsInput').css('display', 'none');
            } else {
                $('#fileUpload').css('display', 'none');
                $('#lessonsInput').css('display', 'block');
            }
        }
    </script>
    <script>
        $(document).ready(function () {
            let currentLessonTitleId = null;
            let deleteModal = $('#deleteModal');
            $(document).on('click', '.show-delete-modal', function (e) {
                currentLessonTitleId = $(this).data('lesson_tittle_id');
                let lesson_tittle = $(this).data('lesson_tittle');
                $("#lesson_tittle").html(lesson_tittle);

                $('#deleteModal').modal('show');
            });
            deleteModal.find("button.btn-delete-action").on("click", function (event) {
                event.preventDefault();
                if (currentLessonTitleId !== null) {
                    $.ajax({
                        url: "<?php echo e(route("subject.delete-class-subject")); ?>",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentLessonTitleId,
                        },
                        beforeSend: function () {
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if (data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>' + data.error + '</b></span>');
                            }

                            if (data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>' + data.success + '</b></span>');
                                window.setTimeout(function () {
                                    window.location.href = "<?php echo e(route("subject.lesson-title")); ?>";
                                }, 2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

            // when subject group dropdown changes
            $('#subject_group_id').change(function () {
                var subject_group_id = $(this).val();
                getSubSystem(subject_group_id, 'subject_group_sub_system_id')

                function getSubSystem(subject_group_id, sub_system_select_control) {
                    if (subject_group_id !== "") {
                        $('#' + sub_system_select_control).html("");
                        var subject_group_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                        $.ajax({
                            type: "GET",
                            url: "<?php echo e(route('sub-system.get')); ?>?subject_group_id=" + subject_group_id,
                            success: function (data) {
                                var subjectGroupClass = data.subject_group_class;
                                var sub_system_id = subjectGroupClass.sub_system_id;
                                if (data) {
                                    $("#subject_group_sub_system_id").empty();
                                    $.each(data.sub_systems, function (key, value) {
                                        var sel = "";
                                        if (subjectGroupClass.sub_system_id === value.id) {
                                            sel = "selected";
                                        }
                                        subject_group_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                    });
                                } else {
                                    $("#subject_group_sub_system_id").empty();
                                }
                                $('#' + sub_system_select_control).append(subject_group_data);


                                if (sub_system_id !== 0) {
                                    getEducationType(sub_system_id, 'education_type_id')
                                    function getEducationType(sub_system_id, education_type_select_control) {
                                        if (sub_system_id !== "") {
                                            $('#' + education_type_select_control).html("");
                                            var education_type_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                            $.ajax({
                                                type: "GET",
                                                url: "<?php echo e(route('education-type.get')); ?>?sub_system_id=" + sub_system_id,
                                                success: function (data) {
                                                    if (data) {
                                                        $("#education_type_id").empty();
                                                        $.each(data, function (key, value) {
                                                            var sel = "";
                                                            if (subjectGroupClass.education_type_id === value.id) {
                                                                sel = "selected";
                                                            }
                                                            education_type_data += "<option value=" + value.id + value.type + " " + sel + ">" + value.designation + "</option>";
                                                        });
                                                    } else {
                                                        $("#education_type_id").empty();
                                                    }
                                                    $('#' + education_type_select_control).append(education_type_data);

                                                    var educationTypeId = $("#education_type_id").val();
                                                    if(educationTypeId !== 0) {

                                                        function processInput(educationTypeId) {
                                                            var output = [];
                                                            var json = educationTypeId.split(' '); // Split text by spaces into array

                                                            json.forEach(function (item) { // Loop through each array item
                                                                var out = item.replace(/\'/g,''); // Remove all single quote '  from chunk
                                                                out = out.split(/(\d+)/); // Now again split the chunk by Digits into array
                                                                out = out.filter(Boolean); // With Boolean we can filter out False Boolean Values like -> false, null, 0
                                                                output.push(out);
                                                            });

                                                            return output;
                                                        }

                                                        var outputId = processInput(educationTypeId[0]);
                                                        var outputType = processInput(educationTypeId[1]);

                                                        if (outputType == "G") {
                                                            getClass(outputId, 'class_id')
                                                            function getClass(education_type_id, class_select_control) {
                                                                $('#' + class_select_control).html("");
                                                                var class_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                                                $.ajax({
                                                                    type: "GET",
                                                                    url: "<?php echo e(route('class.get')); ?>?education_type_id=" + education_type_id,
                                                                    success: function (data) {
                                                                        if (data) {
                                                                            $('#classInput').css('display', 'block');
                                                                            $('#subjectInput').css('display', 'none');
                                                                            $('#subEducationTypeInput').css('display', 'none');
                                                                            $('#specialtyInput').css('display', 'none');
                                                                            $('#specialtyClassInput').css('display', 'none');
                                                                            $('#levelInput').css('display', 'none');
                                                                            $('#levelClassInput').css('display', 'none');

                                                                            $("#class_id").empty();
                                                                            $.each(data, function (key, value) {
                                                                                var sel = "";
                                                                                if (subjectGroupClass.class_id === value.id) {
                                                                                    sel = "selected";
                                                                                }
                                                                                class_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                                                            });
                                                                        } else {
                                                                            $("#class_id").empty();
                                                                        }
                                                                        $('#' + class_select_control).append(class_data);
                                                                    }
                                                                });

                                                                $.ajax({
                                                                    type: "GET",
                                                                    url: "<?php echo e(route('subject.subject-group-subject')); ?>?subject_group_id=" + subject_group_id,
                                                                    success: function(data) {
                                                                        if (data) {
                                                                            $('#subjectInput').css('display', 'block');
                                                                            $('#levelInput').css('display', 'none');
                                                                            $('#levelClassInput').css('display', 'none');
                                                                            $('#subEducationTypeInput').css('display', 'none');
                                                                            $('#specialtyInput').css('display', 'none');
                                                                            $('#specialtyClassInput').css('display', 'none');

                                                                            $("#subject_id").empty();
                                                                            $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                                                            $.each(data, function(key, value) {
                                                                                $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                                                            });
                                                                        } else {
                                                                            $("#subject_id").empty();
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        } else  {
                                                            $("#class_id").empty();
                                                        }

                                                        if (outputType == "T") {
                                                            getSubEducationType(outputId, 'sub_education_type_id')
                                                            function getSubEducationType(education_type_id, sub_education_type_select_control) {
                                                                $('#' + sub_education_type_select_control).html("");
                                                                var sub_education_type_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                                                $.ajax({
                                                                    type: "GET",
                                                                    url: "<?php echo e(route('sub-education-type.get')); ?>?education_type_id=" + education_type_id,
                                                                    success: function(data) {
                                                                        if (data) {
                                                                            $('#classInput').css('display', 'none');
                                                                            $('#subjectInput').css('display', 'none');
                                                                            $('#levelInput').css('display', 'none');
                                                                            $('#levelClassInput').css('display', 'none');
                                                                            $('#subEducationTypeInput').css('display', 'block');
                                                                            $('#specialtyInput').css('display', 'none');
                                                                            $('#specialtyClassInput').css('display', 'none');

                                                                            $("#sub_education_type_id").empty();
                                                                            $.each(data, function (key, value) {
                                                                                var sel = "";
                                                                                if (subjectGroupClass.sub_education_type_id === value.id) {
                                                                                    sel = "selected";
                                                                                }
                                                                                sub_education_type_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                                                            });
                                                                        } else {
                                                                            $("#sub_education_type_id").empty();
                                                                        }
                                                                        $('#' + sub_education_type_select_control).append(sub_education_type_data);

                                                                        var sub_education_type_id = $("#sub_education_type_id").val();

                                                                        getSubEducationTypSpecialty(sub_education_type_id, 'specialty_id')
                                                                        function getSubEducationTypSpecialty(sub_education_type_id, specialty_select_control) {
                                                                            $('#' + specialty_select_control).html("");
                                                                            var specialty_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                                                            $.ajax({
                                                                                type: "GET",
                                                                                url: "<?php echo e(route('specialty.get')); ?>?sub_education_type_id=" + sub_education_type_id,
                                                                                success: function(data) {
                                                                                    if (data) {
                                                                                        $('#classInput').css('display', 'none');
                                                                                        $('#levelInput').css('display', 'none');
                                                                                        $('#levelClassInput').css('display', 'none');
                                                                                        $('#subEducationTypeInput').css('display', 'block');
                                                                                        $('#specialtyInput').css('display', 'block');
                                                                                        $('#specialtyClassInput').css('display', 'block');

                                                                                        $("#specialty_id").empty();
                                                                                        $.each(data, function (key, value) {
                                                                                            var sel = "";
                                                                                            if (subjectGroupClass.specialty_id === value.id) {
                                                                                                sel = "selected";
                                                                                            }
                                                                                            specialty_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                                                                        });
                                                                                    } else {
                                                                                        $("#specialty_id").empty();
                                                                                    }
                                                                                    $('#' + specialty_select_control).append(specialty_data);

                                                                                    var specialty_id = $("#specialty_id").val();

                                                                                    getSpecialtyClass(specialty_id, 'specialty_class_id')
                                                                                    function getSpecialtyClass(specialty_id, specialty_class_select_control) {
                                                                                        $('#' + specialty_class_select_control).html("");
                                                                                        var specialty_class_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                                                                        $.ajax({
                                                                                            type: "GET",
                                                                                            url: "<?php echo e(route('class.get-specialty-classes')); ?>?specialty_id=" + specialty_id,
                                                                                            success: function(data) {
                                                                                                if (data) {
                                                                                                    $('#classInput').css('display', 'none');
                                                                                                    $('#levelInput').css('display', 'none');
                                                                                                    $('#levelClassInput').css('display', 'none');
                                                                                                    $('#subEducationTypeInput').css('display', 'block');
                                                                                                    $('#specialtyInput').css('display', 'block');
                                                                                                    $('#specialtyClassInput').css('display', 'block');

                                                                                                    $("#specialty_class_id").empty();
                                                                                                    $.each(data, function (key, value) {
                                                                                                        var sel = "";
                                                                                                        if (subjectGroupClass.specialty_class_id  === value.id) {
                                                                                                            sel = "selected";
                                                                                                        }
                                                                                                        specialty_class_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                                                                                    });
                                                                                                } else {
                                                                                                    $("#specialty_class_id").empty();
                                                                                                }
                                                                                                $('#' + specialty_class_select_control).append(specialty_class_data);

                                                                                            }
                                                                                        });

                                                                                        $.ajax({
                                                                                            type: "GET",
                                                                                            url: "<?php echo e(route('subject.subject-group-subject')); ?>?subject_group_id=" + subject_group_id,
                                                                                            success: function(data) {
                                                                                                if (data) {
                                                                                                    $('#subjectInput').css('display', 'block');
                                                                                                    $("#subject_id").empty();
                                                                                                    $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                                                                                    $.each(data, function(key, value) {
                                                                                                        $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                                                                                    });
                                                                                                } else {
                                                                                                    $("#subject_id").empty();
                                                                                                }
                                                                                            }
                                                                                        });
                                                                                    }
                                                                                }
                                                                            });
                                                                        }
                                                                    }
                                                                });
                                                            }
                                                        } else {
                                                            $("#sub_education_type_id").empty();
                                                            $("#specialty_id").empty();
                                                            $("#specialty_class_id").empty();
                                                        }

                                                        if (outputType == "E") {
                                                            getLevels(outputId, 'level_id')
                                                            function getLevels(education_type_id, level_select_control) {
                                                                $('#' + level_select_control).html("");
                                                                var level_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                                                $.ajax({
                                                                    type: "GET",
                                                                    url: "<?php echo e(route('levels.get')); ?>?education_type_id=" + education_type_id,
                                                                    success: function(data) {
                                                                        if (data) {
                                                                            $('#classInput').css('display', 'none');
                                                                            $('#subEducationTypeInput').css('display', 'none');
                                                                            $('#specialtyInput').css('display', 'none');
                                                                            $('#specialtyClassInput').css('display', 'none');
                                                                            $('#levelInput').css('display', 'block');
                                                                            $('#levelClassInput').css('display', 'block');

                                                                            $("#level_id").empty();
                                                                            $.each(data, function (key, value) {
                                                                                var sel = "";
                                                                                if (subjectGroupClass.level_id === value.id) {
                                                                                    sel = "selected";
                                                                                }
                                                                                level_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                                                            });
                                                                        } else {
                                                                            $("#level_id").empty();
                                                                        }
                                                                        $('#' + level_select_control).append(level_data);


                                                                        var level_id = $("#level_id").val();

                                                                        getLevelClass(level_id, 'level_class_id')
                                                                        function  getLevelClass(level_id, level_class_select_control) {
                                                                            $('#' + level_class_select_control).html("");
                                                                            var level_class_data = '<option value=""><?php echo e(__("messages.select")); ?></option>';
                                                                            $.ajax({
                                                                                type: "GET",
                                                                                url: "<?php echo e(route('level-classes.get')); ?>?level_id=" + level_id,
                                                                                success: function (data) {
                                                                                    if (data) {
                                                                                        $('#classInput').css('display', 'none');
                                                                                        $('#subEducationTypeInput').css('display', 'none');
                                                                                        $('#specialtyInput').css('display', 'none');
                                                                                        $('#specialtyClassInput').css('display', 'none');
                                                                                        $('#levelInput').css('display', 'block');
                                                                                        $('#levelClassInput').css('display', 'block');

                                                                                        $("#level_class_id").empty();
                                                                                        $.each(data, function (key, value) {
                                                                                            var sel = "";
                                                                                            if (subjectGroupClass.level_class_id === value.id) {
                                                                                                sel = "selected";
                                                                                            }
                                                                                            level_class_data += "<option value=" + value.id + " " + sel + ">" + value.designation + "</option>";
                                                                                        });
                                                                                    } else {
                                                                                        $("#level_class_id").empty();
                                                                                    }
                                                                                    $('#' + level_class_select_control).append(level_class_data);
                                                                                }
                                                                        });

                                                                            $.ajax({
                                                                                type: "GET",
                                                                                url: "<?php echo e(route('subject.subject-group-subject')); ?>?subject_group_id=" + subject_group_id,
                                                                                success: function(data) {
                                                                                    if (data) {
                                                                                        $('#subjectInput').css('display', 'block');
                                                                                        $("#subject_id").empty();
                                                                                        $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                                                                        $.each(data, function(key, value) {
                                                                                            $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                                                                        });
                                                                                    } else {
                                                                                        $("#subject_id").empty();
                                                                                    }
                                                                                }
                                                                            });
                                                                    }
                                                                }
                                                            });
                                                        }
                                                        } else {
                                                            $("#level_id").empty();
                                                            $("#level_class_id").empty();
                                                        }
                                                    }
                                                },
                                            });
                                        }
                                    }
                                }
                            },
                        });
                    }
                }
            });

        });
    </script>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $('#example').DataTable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.admin.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minesec/public_html/dev.minesec.online/resources/views/admin/subject/lesson_titles/index.blade.php ENDPATH**/ ?>