<?php
$languages = app('languages');
$user = auth()->user();
$userLocale = $user->{"locale"};
$sessionLocale = app()->getLocale();
?>
<!doctype html>
<html lang="en">
<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<!--favicon-->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.png')); ?>" type="image/png" />
	<!--plugins-->
	<?php echo $__env->yieldContent("style"); ?>
    <link href="<?php echo e(asset('assets/plugins/simplebar/css/simplebar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/plugins/metismenu/css/metisMenu.min.css')); ?>" rel="stylesheet" />
    <!-- loader-->
    <link href="<?php echo e(asset('assets/css/pace.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('assets/js/pace.min.js')); ?>"></script>

    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/icons.css')); ?>" rel="stylesheet">

    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/dark-theme.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/semi-dark.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/header-colors.css')); ?>" />
    <title><?php echo $__env->yieldContent('title'); ?></title>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--start header -->
		<?php echo $__env->make("layouts.admin.header", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--end header -->
		<!--navigation-->
		<?php echo $__env->make("layouts.admin.nav", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--end navigation-->
		<!--start page wrapper -->
		<?php echo $__env->yieldContent("wrapper"); ?>
		<!--end page wrapper -->
		<!--start overlay-->
		<div class="overlay toggle-icon"></div>
		<!--end overlay-->
		<!--Start Back To Top Button--> <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
		<!--End Back To Top Button-->
		<footer class="page-footer">
			<p class="mb-0">Copyright © <script>document.write(new Date().getFullYear())</script>. <?php echo e(__("messages.all_rights_reserve")); ?></p>
		</footer>
	</div>
	<!--end wrapper-->

	<!-- Bootstrap JS -->
	<script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
	<!--plugins-->
	<script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/simplebar/js/simplebar.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/metismenu/js/metisMenu.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js')); ?>"></script>
	<!--app JS-->
	<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
    <script>
        $(document).ready(function (e) {
            $('#locale_en').on('click', function () {
                changeToEnglish();
            });

            $('#locale_fr').on('click', function () {
                changeToFrench();
            });
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        function changeToEnglish() {
            var locale_en = $("#locale_en").val();
            $.ajax({
                url: "<?php echo e(route('changLanguage')); ?>",
                type: "POST",
                // async: true,
                data: {
                    locale: locale_en,
                    requestType: "CL",
                },
                timeout: 6000,
                dataType: "json",
                beforeSend: function (xhr, settings) {
                },
                success: function (data) {
                    window.location.reload('true');
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });
        }

        function changeToFrench() {
            var locale_fr = $("#locale_fr").val();
            $.ajax({
                url: "<?php echo e(route('changLanguage')); ?>",
                type: "POST",
                // async: true,
                data: {
                    locale: locale_fr,
                    requestType: "CL",
                },
                timeout: 6000,
                dataType: "json",
                beforeSend: function (xhr, settings) {
                },
                success: function (data) {
                    window.location.reload('true');
                },
                error: function (xhr, textStatus, errorThrown) {
                }
            });
        }
    </script>

    <script>
        $(document).ready(function() {
            $('#classInput').css('display', 'none'); // Hide the text input box in default
            $('#subEducationTypeInput').css('display', 'none'); // Hide the text input box in default
            $('#specialtyInput').css('display', 'none'); // Hide the text input box in default
            $('#specialtyClassInput').css('display', 'none'); // Hide the text input box in default
            $('#levelInput').css('display', 'none'); // Hide the text input box in default
            $('#levelClassInput').css('display', 'none'); // Hide the text input box in default
            $('#subjectInput').css('display', 'none'); // Hide the text input box in default
            $('#classSubjects').css('display', 'none'); // Hide the text input box in default
            $('#LessonTitles').css('display', 'none'); // Hide the text input box in default

            // when sub system dropdown changes
            $('#sub_system_id').change(function() {
                var subSystemId = $(this).val();
                if (subSystemId) {
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('education-type.get')); ?>?sub_system_id=" + subSystemId,
                        success: function(data) {
                            if (data) {
                                $("#education_type_id").empty();
                                $("#education_type_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(data, function(key, value) {
                                    $("#education_type_id").append('<option value="' + value.id + value.type +' ">' + value.designation +'</option>');
                                });
                            } else {
                                $("#education_type_id").empty();
                            }
                        }
                    });

                    var div_data = "";
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('subject.get-sub-system-subjects')); ?>?sub_system_id=" + subSystemId,
                        success: function(data) {
                            if (data) {
                                $.each(data, function (i, obj)
                                {
                                    var check = "";
                                    div_data += "<div class='form-check'>";
                                    div_data += "<label>";
                                    div_data += "<input type='checkbox' class='form-check-input' name='subjectIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                    div_data += "</label>";
                                    div_data += "</div>";
                                });
                                $('.subject_checkbox').html(div_data);
                            }
                        }
                    });

                } else {
                    $("#education_type_id").empty();
                    $("#class_id").empty();
                }
            });

            let currentEducationTypedId = null;

            // when education type dropdown changes
            $('#education_type_id').on('change', function() {
                var educationTypeId = $(this).val();
                function processInput(educationTypeId) {
                    var output = [];
                    var json = educationTypeId.split(' '); // Split text by spaces into array

                    json.forEach(function (item) { // Loop through each array item
                        var out = item.replace(/\'/g,''); // Remove all single quote '  from chunk
                        out = out.split(/(\d+)/); // Now again split the chunk by Digits into array
                        out = out.filter(Boolean); // With Boolean we can filter out False Boolean Values like -> false, null, 0
                        output.push(out);
                    });

                    return output;
                }

                var outputId = processInput(educationTypeId[0]);
                var outputType = processInput(educationTypeId[1]);

                if (outputType == "G") {
                    var div_data = "";
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('class.get')); ?>?education_type_id=" + outputId,
                        success: function(data) {
                            if (data) {
                                $('#classInput').css('display', 'block');
                                $('#subEducationTypeInput').css('display', 'none');
                                $('#specialtyInput').css('display', 'none');
                                $('#specialtyClassInput').css('display', 'none');
                                $('#levelInput').css('display', 'none');
                                $('#levelClassInput').css('display', 'none');
                                $('#LessonTitles').css('display', 'none');

                                $("#class_id").empty();
                                $("#class_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(data, function(key, value) {
                                    $("#class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });

                                // $.each(data, function (i, obj)
                                // {
                                //     var check = "";
                                //     // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                //     //     check = "checked";
                                //     // }
                                //     div_data += "<div class='form-check'>";
                                //     div_data += "<label>";
                                //     div_data += "<input type='radio' class='form-check-input' id='class_id' name='classIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                //     div_data += "</label>";
                                //     div_data += "</div>";
                                // });
                                // $('.class_checkbox').html(div_data);

                            } else {
                                $("#class_id").empty();
                            }
                            $('#class_id').on('change', function() {
                                var educationTypeOutPutId = outputId[0][0];
                                var class_id = $("#class_id").val();
                                if (class_id) {
                                    // var class_subject_data = "";
                                    $.ajax({
                                        url: "<?php echo e(route('home.get-class-subjects')); ?>",
                                        type: "POST",
                                        data: {
                                            "_token": "<?php echo e(csrf_token()); ?>",
                                            type: "Gen",
                                            education_type_id: educationTypeOutPutId,
                                            class_id: class_id,
                                        },
                                        timeout: 6000,
                                        dataType: "json",
                                        beforeSend: function (xhr, settings) {
                                        },
                                        success: function (data) {
                                            if (data) {
                                                $('#classSubjects').css('display', 'block');
                                                $('#LessonTitles').css('display', 'none');
                                                $("#subject_id").empty();
                                                $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                                $.each(data.data, function(key, value) {
                                                    $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                                });

                                                // $.each(data.data, function (i, obj) {
                                                //     var check = "";
                                                //     // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                                //     //     check = "checked";
                                                //     // }
                                                //     class_subject_data += "<div class='form-check'>";
                                                //     class_subject_data += "<label>";
                                                //     class_subject_data += "<input type='radio' class='form-check-input' name='subject_id' value='" + obj.id + "' " + check + ">" + obj.designation;
                                                //     class_subject_data += "</label>";
                                                //     class_subject_data += "</div>";
                                                // });
                                                // $('.class_subjects').html(class_subject_data);
                                            }
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                        }
                                    });
                                } else  {
                                    $("#subject_id").empty();
                                }

                                $('#subject_id').on('change', function() {
                                    var subSystemId = $("#sub_system_id").val();
                                    var educationTypeOutPutId = outputId[0][0];
                                    var class_id = $("#class_id").val();
                                    var subject_id = $("#subject_id").val();
                                    if (subject_id) {
                                        var class_subject_data = "";
                                        $.ajax({
                                            url: "<?php echo e(route('subject.get-lesson-titles')); ?>",
                                            type: "POST",
                                            data: {
                                                type: "Gen",
                                                request_type: "class lessons",
                                                sub_system_id : subSystemId,
                                                education_type_id: educationTypeOutPutId,
                                                class_id: class_id,
                                                subject_id: subject_id,
                                            },
                                            timeout: 6000,
                                            dataType: "json",
                                            beforeSend: function (xhr, settings) {
                                            },
                                            success: function (data) {
                                                if (data) {
                                                    $('#LessonTitles').css('display', 'block');
                                                    $.each(data.data, function (i, obj) {
                                                        class_subject_data += "<div class='form-check'>";
                                                        class_subject_data += "<label>";
                                                        class_subject_data += "<input type='radio' class='form-check-input' required name='lesson_title_id' value='" + obj.id + "'>" + obj.title;
                                                        class_subject_data += "<div class='invalid-feedback'><?php echo e(__('error.filed_required')); ?></div>";
                                                        class_subject_data += "</label>";
                                                        class_subject_data += "</div>";
                                                    });
                                                    $('.lesson_titles').html(class_subject_data);
                                                }
                                            },
                                            error: function (xhr, textStatus, errorThrown) {
                                            }
                                        });
                                    }
                                });
                            });
                        }
                    });
                } else {
                    $("#class_id").empty();
                }

                if (outputType == "T") {
                    currentEducationTypedId = outputId[0][0];
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('sub-education-type.get')); ?>?education_type_id=" + outputId,
                        success: function(res) {
                            if (res) {
                                $('#classInput').css('display', 'none');
                                $('#levelInput').css('display', 'none');
                                $('#levelClassInput').css('display', 'none');
                                $('#subEducationTypeInput').css('display', 'block');
                                $('#specialtyInput').css('display', 'none');
                                $('#specialtyClassInput').css('display', 'none');
                                $('#classSubjects').css('display', 'none');
                                $('#LessonTitles').css('display', 'none');

                                $("#sub_education_type_id").empty();
                                $("#sub_education_type_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(res, function(key, value) {
                                    $("#sub_education_type_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });
                            } else {
                                $("#sub_education_type_id").empty();
                            }
                        }
                    });
                } else {
                    $("#sub_education_type_id").empty();
                    $("#specialty_id").empty();
                }

                if (outputType == "E") {
                    currentEducationTypedId = outputId[0][0];
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('levels.get')); ?>?education_type_id=" + outputId,
                        success: function(res) {
                            if (res) {
                                $('#classInput').css('display', 'none');
                                $('#subEducationTypeInput').css('display', 'none');
                                $('#specialtyInput').css('display', 'none');
                                $('#specialtyClassInput').css('display', 'none');
                                $('#levelInput').css('display', 'block');
                                $('#levelClassInput').css('display', 'none');
                                $('#LessonTitles').css('display', 'none');

                                $("#level_id").empty();
                                $("#level_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(res, function(key, value) {
                                    $("#level_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });
                            } else {
                                $("#level_id").empty();
                            }
                        }
                    });
                } else {
                    $("#level_id").empty();
                    $("#level_class_id").empty();
                }
            });

            // when sub education type dropdown changes
            $('#sub_education_type_id').on('change', function() {
                var subEducationTypeId = $(this).val();
                if (subEducationTypeId) {
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('specialty.get')); ?>?sub_education_type_id=" + subEducationTypeId,
                        success: function(res) {
                            if (res) {
                                $('#specialtyClassInput').css('display', 'none');
                                $('#specialtyInput').css('display', 'block');
                                $('#classSubjects').css('display', 'none');
                                $('#LessonTitles').css('display', 'none');
                                $("#specialty_id").empty();
                                $("#specialty_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(res, function(key, value) {
                                    $("#specialty_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });
                            } else {
                                $("#specialty_id").empty();
                            }
                        }
                    });
                } else {
                    $("#specialty_id").empty();
                }
            });

            $('#specialty_id').on('change', function() {
                var specialtyId = $(this).val();
                if (specialtyId) {
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('class.get-specialty-classes')); ?>?specialty_id=" + specialtyId,
                        success: function(data) {
                            var div_data = "";
                            if (data) {
                                $('#specialtyClassInput').css('display', 'block');
                                $('#classSubjects').css('display', 'none');
                                $('#LessonTitles').css('display', 'none');
                                $("#specialty_class_id").empty();
                                $("#specialty_class_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(data, function(key, value) {
                                    $("#specialty_class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });
                                // $.each(data, function (i, obj)
                                // {
                                //     var check = "";
                                //     // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                //     //     check = "checked";
                                //     // }
                                //     div_data += "<div class='form-check'>";
                                //     div_data += "<label>";
                                //     div_data += "<input type='checkbox' class='form-check-input' id='specialty_class_id' name='specialtyClassIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                //     div_data += "</label>";
                                //     div_data += "</div>";
                                // });
                                // $('.specialtyClass_checkbox').html(div_data);
                            } else {
                                $("#specialty_class_id").empty();
                            }
                            $('#specialty_class_id').on('change', function() {
                                var specialty_class_id = $("#specialty_class_id").val();
                                if (specialty_class_id) {
                                    // var class_subject_data = "";
                                    $.ajax({
                                        url: "<?php echo e(route('home.get-class-subjects')); ?>",
                                        type: "POST",
                                        data: {
                                            "_token": "<?php echo e(csrf_token()); ?>",
                                            type: "Tech",
                                            specialty_id: specialtyId,
                                            specialty_class_id: specialty_class_id,
                                        },
                                        timeout: 6000,
                                        dataType: "json",
                                        beforeSend: function (xhr, settings) {
                                        },
                                        success: function (data) {
                                            if (data) {
                                                $('#classSubjects').css('display', 'block');
                                                $('#LessonTitles').css('display', 'none');
                                                $("#subject_id").empty();
                                                $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                                $.each(data.data, function(key, value) {
                                                    $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                                });

                                                // $.each(data.data, function (i, obj) {
                                                //     var check = "";
                                                //     // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                                //     //     check = "checked";
                                                //     // }
                                                //     class_subject_data += "<div class='form-check'>";
                                                //     class_subject_data += "<label>";
                                                //     class_subject_data += "<input type='radio' class='form-check-input' name='subject_id' value='" + obj.id + "' " + check + ">" + obj.designation;
                                                //     class_subject_data += "</label>";
                                                //     class_subject_data += "</div>";
                                                // });
                                                // $('.class_subjects').html(class_subject_data);
                                            }
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                        }
                                    });
                                } else  {
                                    $("#subject_id").empty();
                                }

                                $('#subject_id').on('change', function() {
                                    var subSystemId = $("#sub_system_id").val();
                                    var educationTypeOutPutId = currentEducationTypedId;
                                    var sub_education_type_id = $("#sub_education_type_id").val();
                                    var specialty_id = $("#specialty_id").val();
                                    var specialty_class_id = $("#specialty_class_id").val();
                                    var subject_id = $("#subject_id").val();
                                    if (subject_id) {
                                        var class_subject_data = "";
                                        $.ajax({
                                            url: "<?php echo e(route('subject.get-lesson-titles')); ?>",
                                            type: "POST",
                                            data: {
                                                type: "Tech",
                                                request_type: "class lessons",
                                                sub_system_id : subSystemId,
                                                education_type_id: educationTypeOutPutId,
                                                sub_education_type_id: sub_education_type_id,
                                                specialty_id: specialty_id,
                                                specialty_class_id: specialty_class_id,
                                                subject_id: subject_id,
                                            },
                                            timeout: 6000,
                                            dataType: "json",
                                            beforeSend: function (xhr, settings) {
                                            },
                                            success: function (data) {
                                                if (data) {
                                                    $('#LessonTitles').css('display', 'block');
                                                    $.each(data.data, function (i, obj) {
                                                        class_subject_data += "<div class='form-check'>";
                                                        class_subject_data += "<label>";
                                                        class_subject_data += "<input type='radio' class='form-check-input' required name='lesson_title_id' value='" + obj.id + "'>" + obj.title;
                                                        class_subject_data += "<div class='invalid-feedback'><?php echo e(__('error.filed_required')); ?></div>";
                                                        class_subject_data += "</label>";
                                                        class_subject_data += "</div>";
                                                    });
                                                    $('.lesson_titles').html(class_subject_data);
                                                }
                                            },
                                            error: function (xhr, textStatus, errorThrown) {
                                            }
                                        });
                                    }
                                });
                            });
                        }
                    });
                } else {
                    $("#specialty_class_id").empty();
                }
            });

            $('#level_id').on('change', function() {
                var levelId = $(this).val();
                if (levelId) {
                    $.ajax({
                        type: "GET",
                        url: "<?php echo e(route('level-classes.get')); ?>?level_id=" + levelId,
                        success: function(data) {
                            if (data) {
                                $('#levelClassInput').css('display', 'block');
                                $('#classSubjects').css('display', 'none');
                                $('#LessonTitles').css('display', 'none');
                                $("#level_class_id").empty();
                                $("#level_class_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                $.each(data, function(key, value) {
                                    $("#level_class_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                });
                                // $.each(data, function (i, obj)
                                // {
                                //     var check = "";
                                //     // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                //     //     check = "checked";
                                //     // }
                                //     div_data += "<div class='form-check'>";
                                //     div_data += "<label>";
                                //     div_data += "<input type='checkbox' class='form-check-input' id='level_class_id' name='leveClassIds[]' value='" + obj.id + "' " + check + ">" + obj.designation;
                                //     div_data += "</label>";
                                //     div_data += "</div>";
                                // });
                                // $('.levelClass_checkbox').html(div_data);
                            } else {
                                $("#level_class_id").empty();
                            }
                            $('#level_class_id').on('change', function() {
                                var level_class_id = $("#level_class_id").val();
                                if (level_class_id) {
                                    // var class_subject_data = "";
                                    $.ajax({
                                        url: "<?php echo e(route('home.get-class-subjects')); ?>",
                                        type: "POST",
                                        data: {
                                            "_token": "<?php echo e(csrf_token()); ?>",
                                            type: "EN",
                                            level_id: levelId,
                                            level_class_id: level_class_id,
                                        },
                                        timeout: 6000,
                                        dataType: "json",
                                        beforeSend: function (xhr, settings) {
                                        },
                                        success: function (data) {
                                            if (data) {
                                                $('#classSubjects').css('display', 'block');
                                                $('#LessonTitles').css('display', 'none');
                                                $("#subject_id").empty();
                                                $("#subject_id").append('<option value=""><?php echo e(__("messages.select")); ?></option>');
                                                $.each(data.data, function(key, value) {
                                                    $("#subject_id").append('<option value="' + value.id + '">' + value.designation + '</option>');
                                                });

                                                // $.each(data.data, function (i, obj) {
                                                //     var check = "";
                                                //     // if (jQuery.inArray(obj.id, post_section_array) !== -1) {
                                                //     //     check = "checked";
                                                //     // }
                                                //     class_subject_data += "<div class='form-check'>";
                                                //     class_subject_data += "<label>";
                                                //     class_subject_data += "<input type='radio' class='form-check-input' name='subject_id' value='" + obj.id + "' " + check + ">" + obj.designation;
                                                //     class_subject_data += "</label>";
                                                //     class_subject_data += "</div>";
                                                // });
                                                // $('.class_subjects').html(class_subject_data);
                                            }
                                        },
                                        error: function (xhr, textStatus, errorThrown) {
                                        }
                                    });
                                } else  {
                                    $("#subject_id").empty();
                                }

                                $('#subject_id').on('change', function() {
                                    var subSystemId = $("#sub_system_id").val();
                                    var educationTypeOutPutId = currentEducationTypedId;
                                    var subject_id = $("#subject_id").val();
                                    if (subject_id) {
                                        var class_subject_data = "";
                                        $.ajax({
                                            url: "<?php echo e(route('subject.get-lesson-titles')); ?>",
                                            type: "POST",
                                            data: {
                                                type: "EN",
                                                request_type: "class lessons",
                                                sub_system_id : subSystemId,
                                                education_type_id: educationTypeOutPutId,
                                                level_id: levelId,
                                                level_class_id: level_class_id,
                                                subject_id: subject_id,
                                            },
                                            timeout: 6000,
                                            dataType: "json",
                                            beforeSend: function (xhr, settings) {
                                            },
                                            success: function (data) {
                                                if (data) {
                                                    $('#LessonTitles').css('display', 'block');
                                                    $.each(data.data, function (i, obj) {
                                                        class_subject_data += "<div class='form-check'>";
                                                        class_subject_data += "<label>";
                                                        class_subject_data += "<input type='radio' class='form-check-input' required name='lesson_title_id' value='" + obj.id + "'>" + obj.title;
                                                        class_subject_data += "<div class='invalid-feedback'><?php echo e(__('error.filed_required')); ?></div>";
                                                        class_subject_data += "</label>";
                                                        class_subject_data += "</div>";
                                                    });
                                                    $('.lesson_titles').html(class_subject_data);
                                                }
                                            },
                                            error: function (xhr, textStatus, errorThrown) {
                                            }
                                        });
                                    }
                                });
                            });
                        }
                    });
                } else {
                    $("#level_class_id").empty();
                }
            });
        });
    </script>
	<?php echo $__env->yieldContent("script"); ?>
</body>
</html>
<?php /**PATH /home/minesec/public_html/dev.minesec.online/resources/views/layouts/admin/master.blade.php ENDPATH**/ ?>