@extends("layouts.inspectorate.master")
@section('title', sprintf('%s - %s', __('messages.digitisation_follow_up'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/select2/css/select2.min.css')}}" rel="stylesheet" />
    <link href="{{asset('assets/plugins/select2/css/select2-bootstrap4.css')}}" rel="stylesheet" />
@endsection

@section("wrapper")
    <!--start page wrapper -->
    <div class="page-wrapper">
        <div class="page-content">
            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.digitisation_follow_up")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="row">
                <div class="col-xl-12 mx-auto">
                    <form class="needs-validation" novalidate enctype="multipart/form-data" action="{{route("inspectorate.digitisation-planning")}}" method="post">
                        @csrf
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <!-- School Start  -->
                                <div class="col-md-2 p-3">
                                    <B> <label for="sub_system_id" class="form-label">{{__("messages.school_year")}}</label> </B>
                                    <select class="form-select" id="session_id" name="session_id" required >
                                        <option value="">{{__("messages.select")}}</option>
                                        @foreach($sessions as $session)
                                            <option value="{{$session->{"id"} }}">{{$session->{"designation"} }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3">
                                    <B> <label for="sub_system_id" class="form-label">{{__("messages.region")}}</label> </B>
                                    <select class="form-select" id="region_id" name="region_id" required >
                                        <option value="">{{__("messages.select")}}</option>
                                        @foreach($regions as $region)
                                            <option value="{{$region->{"id"} }}">{{$region->{"designation"} }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3">
                                    <B> <label for="sub_system_id" class="form-label">{{__("messages.division")}}</label> </B>
                                    <select required id="division_id" name="division_id" class="form-control form-select"></select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-4 p-3">
                                    <B> <label class="form-label">{{__("messages.name_of_school")}} </label></B>
                                    <div class="input-group"><button class="btn btn-outline-secondary" type="button"><i class='bx bx-search'></i></button>
                                        <select class="form-select single-select" id="school_id" name="school_id" aria-label="Example select with button addon">
                                            <option value="">{{__("messages.select")}}</option>
                                            @foreach($schools as $school)
                                                <option value="{{$school->{"id"} }}">{{$school->{"designation"} }}</option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                    </div>
                                </div>
                                <!-- School End  -->


                                <div class="col-md-3 p-3">
                                    <B> <label for="sub_system_id" class="form-label">{{__("messages.sub_systems")}}</label> </B>
                                    <select class="form-select" id="sub_system_id" name="sub_system_id" required >
                                        <option value="">{{__("messages.select")}}</option>
                                        @foreach($subSystems as $subSystem)
                                            <option value="{{$subSystem->{"id"} }}">{{$subSystem->{"designation"} }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3">
                                    <B><label for="education_type_id" class="form-label">{{__("messages.education_type")}}</label></B>
                                    <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="subEducationTypeInput">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.sub_education_type")}}</label></B>
                                    <select class="form-select" id="sub_education_type_id" name="sub_education_type_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="specialtyInput">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.specialty")}}</label></B>
                                    <select class="form-select" id="specialty_id" name="specialty_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="specialtyClassInput">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label></B>
                                    <select class="form-select" id="specialty_class_id" name="specialty_class_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="levelInput">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.level")}}</label></B>
                                    <select class="form-select" id="level_id" name="level_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="levelClassInput">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label></B>
                                    <select class="form-select" id="level_class_id" name="level_class_id" aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="classInput">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label></B>
                                    <select class="form-select" id="class_id" name="class_id"  aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-3 p-3" id="classSubjects">
                                    <B><label for="validationTooltip01" class="form-label">{{__("messages.subject")}}</label></B>
                                    <select class="form-select" id="subject_id_to_digitise" name="subject_id_to_digitise" required aria-label="select example">
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="col-md-4 p-3" id="digitisationStage">
                                    <B> <label for="sub_system_id" class="form-label">{{__("messages.stage")}}</label> </B>
                                    <select class="form-select" id="stage" name="stage" required >
                                        <option value="">{{__("messages.select")}}</option>
                                        @foreach($digitisationStages as $key => $value)
                                            <option value="{{$key }}">{{$value }}</option>
                                        @endforeach
                                    </select>
                                    <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                </div>

                                <div class="row" id="lessonsToDigitise">
                                    <h6 class="modal-title">{{__("messages.lessons")}}</h6>
                                    <div class="col-md-12 lessons_to_digitise">
                                    </div>
                                </div>

                                <div class="row" id="lessonsDigitised">
                                    <h6 class="modal-title">{{__("messages.lessons")}}</h6>
                                    <div class="col-md-12 lessons_digitised">
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div id="success"></div>

                                <div id="save-button">
                                    <button type="submit" class="btn btn-primary">{{__("messages.save")}}</button>
                                </div>

                                <div id="loader" class="visible">
                                    <button class="btn btn-primary " type="button"><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>{{__("messages.loading")}}</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
    <!--end page wrapper -->
@endsection

@section("script")
    <script src="{{asset('assets/plugins/select2/js/select2.min.js')}}"></script>
    <script src="{{asset('assets/js/custom/jquery.form.js')}}"></script>
    <script>
        $("#loader").css("display", "none");
        $("#save-button").css("display", "none");
        $(function () {
            $(document).ready(function () {
                $('form').ajaxForm({
                    beforeSend: function () {
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                        $('#success').empty();
                    },
                    uploadProgress: function () {
                        $("#session_id").prop("disabled", true);
                        $("#region_id").prop("disabled", true);
                        $("#division_id").prop("disabled", true);
                        $("#school_id").prop("disabled", true);
                        $("#sub_system_id").prop("disabled", true);
                        $("#education_type_id").prop("disabled", true);
                        $("#class_id").prop("disabled", true);
                        $("#sub_education_type_id").prop("disabled", true);
                        $("#level_id").prop("disabled", true);
                        $("#level_class_id").prop("disabled", true);
                        $("#specialty_id").prop("disabled", true);
                        $("#specialty_class_id").prop("disabled", true);
                        $("#subject_id_to_digitise").prop("disabled", true);
                        $("#stage").prop("disabled", true);

                        $("#lessonTitleIds").prop("disabled", true);

                        $(':input[type="button"]').prop('disabled', true);
                        $("#loader").css("display", "block");
                        $("#save-button").hide();
                    },

                    complete: function (data) {
                        if(data.responseJSON.error)
                        {
                            $("#loader").hide();
                            $("#save-button").css("display", "block");
                            $('#success').html('<span class="text-danger"><b>'+data.responseJSON.error+'</b></span>');
                            window.setTimeout(function(){location.reload()},3000)
                        }

                        if(data.responseJSON.success)
                        {
                            $("#sub_system_id").prop("disabled", true);
                            $("#education_type_id").prop("disabled", true);
                            $("#class_id").prop("disabled", true);
                            $("#sub_education_type_id").prop("disabled", true);
                            $("#levelInput").prop("disabled", true);
                            $("#levelClassInput").prop("disabled", true);
                            $("#specialty_id").prop("disabled", true);
                            $("#specialty_class_id").prop("disabled", true);
                            $("#term_id").prop("disabled", true);
                            $("#subject_id").prop("disabled", true);
                            $("#upload_type").prop("disabled", true);
                            $("#showUploadField").prop("disabled", true);
                            $("#youtube_lesson_link").prop("disabled", true);
                            $("#video-field").prop("disabled", true);
                            $(':input[type="button"]').prop('disabled', true);
                            $('#success').html('<span class="text-success"><b>'+data.responseJSON.success+'</b></span>');
                            $("#loader").hide();
                            $("#save-button").hide();
                            $("#cancel-button").hide();

                            window.setTimeout(function(){location.reload()},3000)
                        }
                    }
                });
            });
        });

        $('.multiple-select').select2({
            theme: 'bootstrap4',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            allowClear: Boolean($(this).data('allow-clear')),
        });

        $('.single-select').select2({
            theme: 'bootstrap4',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).data('placeholder'),
            allowClear: Boolean($(this).data('allow-clear')),
        });

        $('#region_id').change(function() {
            var regionID = $(this).val();
            if (regionID) {
                $.ajax({
                    type: "GET",
                    url: "{{ route('get-divisions') }}?region_id=" + regionID,
                    success: function(data) {
                        if (data) {
                            $("#division_id").empty();
                            $("#division_id").append('<option>{{__("messages.select")}}</option>');
                            $.each(data, function(key, value) {
                                $("#division_id").append('<option value="' + value.id +' ">' + value.designation +'</option>');
                            });
                        } else {
                            $("#division_id").empty();
                        }
                    }
                });
            } else {
                $("#division_id").empty();
                $("#sub_division_id").empty();
            }
        });

    </script>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'
            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')
            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>
@endsection
