@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.class_subjects'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

            @include("admin.response.global")

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.add_class_subjects")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="{{route("subject.create-class-subject")}}" method="POST">
                                            @csrf
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.subject_group")}}</label>
                                                <input type="text" value="{{ old('designation') }}" name="designation" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label">{{__("messages.sub_systems")}}</label>
                                                <select class="form-select" id="sub_system_id" name="sub_system_id" required> <option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($subSystems as $subSystem)
                                                        <option value="{{$subSystem->{"id"} }}"
                                                        @if($subSystem->{'id'} == old("sub_system_id"))
                                                            {{"selected"}}
                                                            @endif
                                                        >{{$subSystem->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.education_type")}}</label>
                                                <select class="form-select" id="education_type_id" name="education_type_id" required aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                          <div class="col-md-12" id="classInput">
                                          <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                          <select class="form-select" id="class_id" name="class_id"  aria-label="select example">
                                          </select>
                                         <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                          </div>

                                            <div class="col-md-12" id="subEducationTypeInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.sub_education_type")}}</label>
                                                <select class="form-select" id="sub_education_type_id" name="sub_education_type_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-12" id="specialtyInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.specialty")}}</label>
                                                <select class="form-select" id="specialty_id" name="specialty_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-12" id="specialtyClassInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="specialty_class_id" name="specialty_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-12" id="levelInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.level")}}</label>
                                                <select class="form-select" id="level_id" name="level_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <div class="col-md-12" id="levelClassInput">
                                                <label for="validationTooltip01" class="form-label">{{__("messages.class")}}</label>
                                                <select class="form-select" id="level_class_id" name="level_class_id"  aria-label="select example">
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>

                                            <h6 class="mb-0">{{__("messages.subjects")}}</h6>
                                            <div class="col-md-12">
                                                <div class="col-md-12 subject_checkbox">
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>{{__("messages.subject_group")}}</th>
                                                <th>{{__("messages.sub_systems")}}</th>
                                                <th>{{__("messages.education_type")}}</th>
                                                <th>{{__("messages.subject")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach($subjectGroups as $classSubject)
                                                <tr>
                                                    <td><?php echo $classSubject->{"designation"} ?></td>
                                                    <td><?php echo $classSubject->{"subjectGroupClass"}->{"subSystem"}->{"designation"} ?></td>
                                                    <td><?php echo $classSubject->{"subjectGroupClass"}->{"educationType"}->{"designation"} ?></td>
{{--                                                    <td>--}}
{{--                                                        <?php--}}
{{--                                                        if($classSubject->{"subjectGroupClass"}->{"educationTypeClass"} != null) {--}}
{{--                                                            echo $classSubject->{"subjectGroupClass"}->{"educationTypeClass"}->{"educationType"}->{"designation"};--}}
{{--                                                        }--}}

{{--                                                        if($classSubject->{"subjectGroupClass"}->{"specialtyClass"} != null) {--}}
{{--                                                            echo $classSubject->{"subjectGroupClass"}->{"specialtyClass"}->{"specialty"}->{"designation"};--}}
{{--                                                        }--}}

{{--                                                        ?>--}}
{{--                                                    </td>--}}
                                                    <td>
                                                        @foreach($classSubject->{"subjectGroupSubjects"} as $subjectGroupSubject)
                                                            <?php   echo "<div>" .$subjectGroupSubject->{"designation"} . "</div>" ?>
                                                        @endforeach
                                                    </td>
                                                    <td>
                                                        <div class="d-flex order-actions">
                                                            <a href="{{route("subject.edit-class-subject", $classSubject->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                            <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-class_subject_id="{{$classSubject->{"id"} }}" data-class_subject_name="{{$classSubject->{"designation"} }}"  title="{{__("messages.delete")}}"></a>
                                                        </div>
                                                    </td>

                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <!--end row-->
                </div>
            </div>

            @include("admin.subject.class.delete_modal")

        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentClassSubjectId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentClassSubjectId = $(this).data('class_subject_id');
                let class_subject_name = $(this).data('class_subject_name');
                $("#class_subject_name").html(class_subject_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentClassSubjectId !== null) {
                    $.ajax({
                        url: "{{route("subject.delete-class-subject")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentClassSubjectId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("subject.class-subject")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>

    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
@endsection
