@extends("layouts.admin.master")
@section('title', sprintf('%s - %s', __('messages.schools'), __(config('app.name'))))

@section("style")
    <link href="{{asset('assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
@endsection

@section("wrapper")
    <div class="page-wrapper">
        <div class="page-content">

        @include("admin.response.global")

            <!--breadcrumb-->
            <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
                <div class="breadcrumb-title pe-3">{{__("messages.add_school")}}</div>
            </div>
            <!--end breadcrumb-->

            <div class="container">
                <div class="main-body">
                    <!-- start row -->
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="p-4 border rounded">
                                        <form class="row g-3 needs-validation" novalidate action="{{route("schools.create")}}" method="POST">
                                            @csrf
                                            <div class="col-md-12">
                                                <label for="validationCustom04" class="form-label">{{__("messages.region")}}</label>
                                                <select class="form-select" id="region_id" name="region_id" required><option selected disabled value="">{{__("messages.select")}}</option>
                                                    @foreach($regions as $region)
                                                        <option value="{{$region->{"id"} }}">{{$region->{"designation"} }}</option>
                                                    @endforeach
                                                </select>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.school_name")}}</label>
                                                <input type="text" value="{{ old('school_name') }}" name="school_name" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.school_order")}}</label>
                                                <input type="text" value="{{ old('school_order') }}" name="school_order" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.school_category")}}</label>
                                                <input type="text" value="{{ old('school_category') }}" name="school_category" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.school_type")}}</label>
                                                <input type="text" value="{{ old('school_type') }}" name="school_type" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.school_form")}}</label>
                                                <input type="text" value="{{ old('school_form') }}" name="school_form" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-md-12">
                                                <label for="validationCustom03" class="form-label">{{__("messages.school_hierarchy_code")}}</label>
                                                <input type="text" value="{{ old('school_hierarchy_code') }}" name="school_hierarchy_code" class="form-control" id="validationCustom03" required>
                                                <div class="invalid-feedback">{{__("error.filed_required")}}</div>
                                            </div>
                                            <div class="col-12">
                                                <button class="btn btn-primary" style="float: right" type="submit">{{__("messages.save")}}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <form action="{{ route("schools.import")}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="input-group">
                                            <input type="file" name="schools" class="form-control" />
                                            <button type="submit" class="btn btn-primary">{{__("messages.import")}}</button>
                                        </div>
                                    </form>
                                    <hr>
                                    <div class="table-responsive">
                                        <table id="example" class="table table-striped table-bordered" style="width:100%">
                                            <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>{{__("messages.school_name")}}</th>
                                                <th>{{__("messages.school_order")}}</th>
                                                <th>{{__("messages.school_category")}}</th>
                                                <th>{{__("messages.school_type")}}</th>
                                                <th>{{__("messages.school_form")}}</th>
                                                <th>{{__("messages.school_hierarchy_code")}}</th>
                                                <th>{{__("messages.action")}}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                        @foreach($schools as $school)
                                            <tr>
                                                <td><?php echo $school->{"id"} ?></td>
                                                <td><?php echo $school->{"designation"} ?></td>
                                                <td><?php echo $school->{"order"} ?></td>
                                                <td><?php echo $school->{"category"} ?></td>
                                                <td><?php echo $school->{"type"} ?></td>
                                                <td><?php echo $school->{"form"} ?></td>
                                                <td><?php echo $school->{"hierarchy_code"} ?></td>
                                                <td>
                                                    <div class="d-flex order-actions">
                                                        <a href="{{route("schools.edit", $school->{"id"}) }}" class="bx bxs-pencil" title="{{__("messages.edit")}}"></a>
                                                        <a href="#" class="bx bxs-trash ms-3 show-delete-modal"  data-school_id="{{$school->{"id"} }}" data-school_name="{{$school->{"designation"} }}"  title="{{__("messages.delete")}}"></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end row-->
                </div>
            </div>

            @include("admin.school.delete_modal")
        </div>
    </div>
@endsection

@section("script")
    <script>
        $(document).ready(function() {
            let currentSchoolId = null;
            let deleteModal = $('#deleteModal');

            $(document).on('click','.show-delete-modal',function(e) {
                currentSchoolId = $(this).data('school_id');
                let school_name = $(this).data('school_name');
                $("#school_name").html(school_name);

                $('#deleteModal').modal('show');
            });

            deleteModal.find("button.btn-delete-action").on("click", function(event) {
                event.preventDefault();

                if(currentSchoolId !== null) {
                    $.ajax({
                        url: "{{route("schools.delete")}}",
                        type: 'POST',
                        dataType: "json",
                        data: {
                            id: currentSchoolId,
                        },
                        beforeSend: function(){
                            $('#response').empty();
                            $(".spinner").removeClass('d-none');
                            $(".action-buttons-wrapper").addClass('d-none');
                        },
                        success: function (data) {
                            if(data.error) {
                                $(".btn-cancel-action").prop("enabled", true);
                                $(".btn-delete-action").prop("enabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-danger"><b>'+data.error+'</b></span>');
                            }

                            if(data.success) {
                                $(".btn-cancel-action").prop("disabled", true);
                                $(".btn-delete-action").prop("disabled", true);
                                $(".spinner").addClass('d-none');
                                $(".action-buttons-wrapper").removeClass('d-none');
                                $('#response').html('<span class="text-success"><b>'+data.success+'</b></span>');
                                window.setTimeout(function(){
                                    window.location.href = "{{route("schools.index")}}";
                                },2500)
                            }
                        },
                        error: function () {
                            $(".btn-cancel-action").prop("enabled", true);
                            $(".btn-delete-action").prop("enabled", true);
                            $(".spinner").addClass('d-none');
                            $(".action-buttons-wrapper").removeClass('d-none');
                            alert("<?php echo __("error.generic_error") ?>");
                        }
                    });
                }
            });

        });
    </script>
    <script>
        // Example starter JavaScript for disabling form submissions if there are invalid fields
        (function () {
            'use strict'

            // Fetch all the forms we want to apply custom Bootstrap validation styles to
            var forms = document.querySelectorAll('.needs-validation')

            // Loop over them and prevent submission
            Array.prototype.slice.call(forms)
                .forEach(function (form) {
                    form.addEventListener('submit', function (event) {
                        if (!form.checkValidity()) {
                            event.preventDefault()
                            event.stopPropagation()
                        }
                        form.classList.add('was-validated')
                    }, false)
                })
        })()
    </script>

    <script src="{{asset('assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
    <script>
        $(document).ready(function() {
            $('#example').DataTable();
        } );
    </script>
@endsection
