<?php

namespace Database\Seeders;

use App\Models\Division;
use App\Models\DivisionSubDivision;
use App\Models\RegionDivision;
use App\Models\SubDivision;
use App\Models\Region;
use Illuminate\Database\Seeder;

class RegionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $regions = config('seeder.regions');

        foreach ($regions as $key => $value) {
            $region = Region::factory()->create([
                "designation" => $value["designation"],
            ]);

            foreach ($value["divisions"] as $divisionKey => $divisionValue) {
                $division = Division::factory()->create([
                    "designation" => $divisionValue["designation"],
                ]);

                RegionDivision::factory()->create([
                    "region_id" => $region->{"id"},
                    "division_id" => $division->{"id"},
                ]);

                foreach ($divisionValue["sub_divisions"] as $subDivisionsValue) {
                    $subDivisions = SubDivision::factory()->create([
                        "designation" => $subDivisionsValue["designation"],
                    ]);

                DivisionSubDivision::factory()->create([
                        "division_id" => $division->{"id"},
                        "sub_division_id" => $subDivisions->{"id"},
                    ]);
                }
            }
        }
    }
}
