<?php

namespace Database\Seeders;

use App\Models\Inspectorate;
use App\Models\Subject;
use Illuminate\Database\Seeder;

class InspectorateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $inspectorates = config("seeder.inspectorates");

        foreach ($inspectorates as $key => $value) {

          $inspectorate = Inspectorate::factory()->create([
              "designation" => $value["designation"]
          ]);

            foreach ($value["subjects"] as $subject) {
                Subject::factory()->create([
                    "inspectorate_id" => $inspectorate->{"id"},
                    "designation" => $subject["designation"],
                    "type" => $subject["type"],
                ]);
            }
        }
    }

}
