<?php


return [

    /*
 |--------------------------------------------------------------------------
 | Languages
 |--------------------------------------------------------------------------
 */
    'locales' => [
        'English' => 'en',
        'French' => 'fr',
    ],

    /*
 |--------------------------------------------------------------------------
 | All locales codes
 |--------------------------------------------------------------------------
 */
    'locales_keys' => [
        'fr' => 'fr',
        'en' => 'en',
    ],

    /*
|--------------------------------------------------------------------------
| Request types
|--------------------------------------------------------------------------
*/
    'request_type' => [
        'change_locale' => 'CL',
    ],

    /*
|--------------------------------------------------------------------------
| Education types
|--------------------------------------------------------------------------
*/
    'education_type' => [
        'general' => 'Gen',
        'technical' => 'Tech',
        'teacher_training' => 'EN',
    ],

    /*
|--------------------------------------------------------------------------
| Education types
|--------------------------------------------------------------------------
*/
    'subject_type' => [
        'theory' => 'Theory',
        'practical' => 'Practical',
    ],

    /*
|--------------------------------------------------------------------------
| Video length
|--------------------------------------------------------------------------
*/
    'lesson_length' => [
        'one_hour' => 3600,
    ],

    /*
|--------------------------------------------------------------------------
| Video length
|--------------------------------------------------------------------------
*/
    'jingle_length' => [
        'length' => 78,
    ],

    /*
|--------------------------------------------------------------------------
| Role
|--------------------------------------------------------------------------
*/
    'roles' => [
        'super_admin' => 'Super Admin',
        'admin' => 'Admin',
        'lesson_validator' => 'Lesson validator',
        'lesson_recorder' => 'Lesson recorder',
        'lesson_editor' => 'Lesson editor',
        'lesson_publisher' => 'Lesson publisher',
        'ICG' => 'General Inspector Coordinator',
        'CDS' => 'Chief of section',
        'IPN' => 'National Pedagogic Inspector',
        'ICR' => 'Regional Inspector Coordinator',
        'IPR' => 'Regional Pedagogic Inspector',
        'teacher' => 'Teacher',
    ],

    /*
|--------------------------------------------------------------------------
| Role types
|--------------------------------------------------------------------------
*/
    'role_types' => [
        'system_roles' => 1,
        'non_system_roles' => 0,
    ],

    /*
|--------------------------------------------------------------------------
| Constants
|--------------------------------------------------------------------------
*/
    'constants' => [
        'image_extensions' => 'jpeg,jpg,png',
        'max_file_size' => 1024, /* 1MB */
        "active" => 1,
        'default_time_format' => 'H:i',
        'default_date_format' => 'Y-m-d',
        'default_date_time_format' => 'Y-m-d H:i:s',
    ],

    /*
|--------------------------------------------------------------------------
| Gender
|--------------------------------------------------------------------------
*/
    'gender' => [
        'male' => 'Male',
        'female' => 'Female',
    ],

    /*
|--------------------------------------------------------------------------
| Lesson validation status
|--------------------------------------------------------------------------
*/
    'validation_status' => [
        'pending' => 'Pending',
        'rejected' => 'Rejected',
        'validated' => 'Validated',
        'recorded' => 'Recorded',
        'validation_rejected' => 'Validation rejected',
        'edited' => 'Edited',
        'recording_rejected' => 'Recording rejected',
        'segmented' => 'Segmented',
        'editing_rejected' => 'Editing rejected',
        'put_in_claas' => 'Put in claas',
        'segmentation_rejected' => 'Segmentation rejected',
    ],

    /*
|--------------------------------------------------------------------------
| Sub systems
|--------------------------------------------------------------------------
*/
    'sub_systems' => [
        'english_sub_system' => 1,
        'sou_system_francophone' => 2,
    ],

    /*
|--------------------------------------------------------------------------
| Education type
|--------------------------------------------------------------------------
*/
    'education_types' => [
        'general_education' => 1,
        'enseignement_general' => 2,
        'technical_education' => 3,
        'enseignement_technique' => 4,
        'teacher_training' => 5,
        'enseignement_normal' => 6,
    ],

    /*
|--------------------------------------------------------------------------
| Resource destination
|--------------------------------------------------------------------------
*/
    'resource_destination' => [
        'local_server' => 'local_server',
        'you_tube' => 'you_tube',
    ],

    /*
|--------------------------------------------------------------------------
| Validation stage status
|--------------------------------------------------------------------------
*/
    'validation_stage_status' => [
        'submission_pending' => 'Submission pending',
        'submission_validated' => 'Submission validated',
        'submission_rejected' => 'Submission rejected',
        'validation_rejected' => 'Validation rejected',
        'lesson_recorded' => 'Lesson recorded',
        'recording_rejected' => 'Recording rejected',
        'lesson_edited' => 'Lesson edited',
        'editing_rejected' => 'Editing rejected',
        'lesson_segmented' => 'Lesson segmented',
        'segmentation_rejected' => 'Segmentation rejected',
        "lesson_put_in_class" => "Lesson put in class",
    ],

    /*
|--------------------------------------------------------------------------
| Validation stages
|--------------------------------------------------------------------------
*/
    'validation_stage' => [
        'submission' => 'Submission',
        'validation' => 'Validation',
        'recording' => 'Recording',
        'editing' => 'Editing',
        'segmentation' => 'Segmentation',
        'put_in_class' => 'Put in class',
    ],

];


