<?php

namespace App\Services;

use App\Models\SubDivision;
use Exception;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait SubDivisionService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return SubDivision::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all divisions
     *
     * @return Builder[]|Collection
     */
    public static function allDivisions(): Collection|array
    {
        return SubDivision::query()->orderBy('designation')->get();
    }

    /**
     * create division
     *
     * @param string $designation
     * @return SubDivision|Builder|Model|null
     * @throws Exception
     */
    public static function createDivision(string $designation): SubDivision|Model|Builder|null
    {
        try {
            /** @var SubDivision $result */
            $division = self::store([
                "designation" => $designation,
            ]);

            $result = $division;

        } catch (Exception $exception) {
            log_debug(exception: $exception, prefix: 'DivisionService::createDivision');
            $result = null;
        }

        return $result;
    }

    /**
     * Find division by id
     *
     * @param int $id
     * @return Model|Builder|null
     */
    public static function findById(int $id): Model|Builder|null
    {
        return SubDivision::query()->find($id);
    }

}
