<?php

namespace App\Services;

use App\Models\School;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

trait SchoolService
{

    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return School::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Get all schools
     *
     * @return Builder[]|Collection
     */
    public static function allSchools(): Collection|array
    {
        return School::query()->get();
    }

    /**
     * Find by school id
     *
     * @param int $id
     * @return Builder|Builder[]|Collection|Model|null
     */
    public static function findById(int $id): Model|Collection|Builder|array|null
    {
        return School::query()->find($id);
    }

    /**
     * Create school
     *
     * @param array $data
     * @return Builder|Model|null
     */
    public static function createSchool(array $data): Model|Builder|null
    {
        try {
            $school = self::store([
                "category" => $data["school_category"],
                "type" => $data["school_type"],
                "form" => $data["school_form"],
                "hierarchy_code" => $data["school_hierarchy_code"],
                "designation" => $data["school_name"],
                "order" => $data["school_order"],
                "region_id" => $data["region_id"],
            ]);

            $results = $school;
        } catch (\Exception $exception) {
            log_debug($exception, "SchoolService::createSchool");
            $results = null;
        }

        return $results;
    }

    /**
     * Update school
     *
     * @param array $data
     * @return School|null
     */
    public function updateSchool(array $data): ?School
    {
        try {
            $school = $this;

            $school->updateService([
                "category" => $data["school_category"],
                "type" => $data["school_type"],
                "form" => $data["school_form"],
                "hierarchy_code" => $data["school_hierarchy_code"],
                "designation" => $data["school_name"],
                "order" => $data["school_order"],
                "region_id" => $data["region_id"],
            ]);

            $results = $school;
        } catch (\Exception $exception) {
            log_debug($exception, "SchoolService::update");
            $results = null;
        }

        return $results;
    }

    /**
     * Delete school
     *
     * @param $id
     * @return int|null
     */
    public static function deleteSchool($id): ?int
    {
        try {
            $school = School::destroy($id);
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'SchoolService::deleteSchool');
            $school = null;
        }
        return $school;
    }

}
