<?php

namespace App\Services;

use App\Models\DigitisationPlanning;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

trait DigitisationPlanningService
{
    /**
     * Add new record
     *
     * @param array $data
     * @return Builder|Model
     */
    public static function store(array $data): Model|Builder
    {
        return DigitisationPlanning::query()->create($data);
    }

    /**
     * Update existing record
     *
     * @param array $data
     * @return mixed
     */
    public function updateService(array $data): mixed
    {
        return tap($this)->update($data);
    }

    /**
     * Create General Education Digitisation Planning
     *
     * @param array $data
     * @param string $educationTypeId
     * @return Builder|Model|null
     */
    public static function createGenEducationPlanning(array $data, string $educationTypeId): Model|Builder|null
    {
        try {
            $planning = null;

            foreach ($data["lessonTitleIds"] as $lessonTitleId) {
                $planning = self::store([
                    "session_id" => $data["session_id"],
                    "region_id" => $data["region_id"],
                    "division_id" => $data["division_id"],
                    "school_id" => $data["school_id"],
                    "sub_system_id" => $data["sub_system_id"],
                    "education_type_id" => $educationTypeId,
                    "class_id" => $data["class_id"],
                    "subject_id" => $data["subject_id_to_digitise"],
                    "lesson_title_id" => $lessonTitleId,
                ]);
            }

            $results = $planning;
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'DigitisationPlanningService::createGenEducationPlanning');
            $results = null;
        }

        return $results;
    }

    /**
     * Create Technical Education Digitisation Planning
     *
     * @param array $data
     * @param string $educationTypeId
     * @return Builder|Model|null
     */
    public static function createTechEducationPlanning(array $data, string $educationTypeId): Model|Builder|null
    {
        try {
            $planning = null;

            foreach ($data["lessonTitleIds"] as $lessonTitleId) {
                $planning = self::store([
                    "session_id" => $data["session_id"],
                    "region_id" => $data["region_id"],
                    "division_id" => $data["division_id"],
                    "school_id" => $data["school_id"],
                    "sub_system_id" => $data["sub_system_id"],
                    "education_type_id" => $educationTypeId,
                    "sub_education_type_id" => $data["sub_education_type_id"],
                    "specialty_id" => $data["specialty_id"],
                    "class_id" => $data["specialty_class_id"],
                    "subject_id" => $data["subject_id_to_digitise"],
                    "lesson_title_id" => $lessonTitleId,
                ]);
            }

            $results = $planning;
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'DigitisationPlanningService::createTechEducationPlanning');
            $results = null;
        }

        return $results;
    }

    /**
     * Create Teacher Taring Digitisation Panning
     *
     * @param array $data
     * @param string $educationTypeId
     * @return Builder|Model|null
     */
    public static function createTeachTrainingPlanning(array $data, string $educationTypeId): Model|Builder|null
    {
        try {
            $planning = null;

            foreach ($data["lessonTitleIds"] as $lessonTitleId) {
                $planning = self::store([
                    "session_id" => $data["session_id"],
                    "region_id" => $data["region_id"],
                    "division_id" => $data["division_id"],
                    "school_id" => $data["school_id"],
                    "sub_system_id" => $data["sub_system_id"],
                    "education_type_id" => $educationTypeId,
                    "level_id" => $data["level_id"],
                    "class_id" => $data["level_class_id"],
                    "subject_id" => $data["subject_id_to_digitise"],
                    "lesson_title_id" => $lessonTitleId,
                ]);
            }

            $results = $planning;
        } catch (\Exception $exception) {
            log_debug(exception: $exception, prefix: 'DigitisationPlanningService::createTeachTrainingPlanning');
            $results = null;
        }

        return $results;
    }

    /**
     * Get General Education Planed Lessons
     *
     * @param array $data
     * @return array
     */
    public static function getGenEducationPlanning(array $data): array
    {
        $plannedLessons = DigitisationPlanning::query()->with('lessonTitle')
            ->where("session_id", $data["session_id"])
            ->where("region_id", $data["region_id"])
            ->where("division_id", $data["division_id"])
            ->where("school_id", $data["school_id"])
            ->where("sub_system_id", $data["sub_system_id"])
            ->where("education_type_id", $data["education_type_id"])
            ->where("class_id", $data["class_id"])
            ->where("subject_id", $data["subject_id"])->get();

        $lessonsArray = array();
        foreach ($plannedLessons as $lesson) {
            $lessonTitle = $lesson->{"lessonTitle"};
            $lessonsArray[] = array(
                "id" => $lessonTitle->{"id"},
                "title" => $lessonTitle->{"title"},
                "description" => $lessonTitle->{"description"},
            );
        }

        return $lessonsArray;
    }

    /**
     * Get Technical Education Planned Lessons
     *
     * @param array $data
     * @return array
     */
    public static function getTechEducationPlanning(array $data): array
    {
        $plannedLessons = DigitisationPlanning::query()->with('lessonTitle')
            ->where("session_id", $data["session_id"])
            ->where("region_id", $data["region_id"])
            ->where("division_id", $data["division_id"])
            ->where("school_id", $data["school_id"])
            ->where("sub_system_id", $data["sub_system_id"])
            ->where("education_type_id", $data["education_type_id"])
            ->where("sub_education_type_id", $data["sub_education_type_id"])
            ->where("specialty_id", $data["specialty_id"])
            ->where("class_id", $data["specialty_class_id"])
            ->where("subject_id", $data["subject_id"])->get();

        $lessonsArray = array();
        foreach ($plannedLessons as $lesson) {
            $lessonTitle = $lesson->{"lessonTitle"};
            $lessonsArray[] = array(
                "id" => $lessonTitle->{"id"},
                "title" => $lessonTitle->{"title"},
                "description" => $lessonTitle->{"description"},
            );
        }

        return $lessonsArray;
    }

    /**
     * Get Teacher Training Planned Lessons
     * @param array $data
     * @return array
     */
    public static function getTeachTrainingPlanning(array $data): array
    {
        $plannedLessons = DigitisationPlanning::query()->with('lessonTitle')
            ->where("session_id", $data["session_id"])
            ->where("region_id", $data["region_id"])
            ->where("division_id", $data["division_id"])
            ->where("school_id", $data["school_id"])
            ->where("sub_system_id", $data["sub_system_id"])
            ->where("education_type_id", $data["education_type_id"])
            ->where("level_id", $data["level_id"])
            ->where("class_id", $data["level_class_id"])
            ->where("subject_id", $data["subject_id"])->get();

        $lessonsArray = array();
        foreach ($plannedLessons as $lesson) {
            $lessonTitle = $lesson->{"lessonTitle"};
            $lessonsArray[] = array(
                "id" => $lessonTitle->{"id"},
                "title" => $lessonTitle->{"title"},
                "description" => $lessonTitle->{"description"},
            );
        }

        return $lessonsArray;
    }

}
