<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class SchoolRules
{

    /**
     * Import rules
     *
     * @return string[][]
     */
    #[ArrayShape(['schools' => "string[]"])] public static function import(): array
    {
        return [
            'schools' => 'required|file',
        ];
    }

    /**
     * Create school rules
     *
     * @return string[]
     */
    public static function createRules(): array
    {
        return [
            "region_id" => "required|integer|exists:regions,id",
            "school_category" => "required|max:100",
            "school_type" => "required|max:100",
            "school_form" => "required|max:100",
            "school_name" => "required|max:100",
            "school_hierarchy_code" => "required|max:100",
            "school_order" => "required|max:100",
        ];
    }

    /**
     * Edit rule
     *
     * @param $id
     * @return string[]
     */
    public static function edit($id): array
    {
        return [
            "id" => "required|integer|exists:schools",
        ];
    }

    /**
     * Update rules
     *
     * @return string[]
     */
    public static function update(): array
    {
        return [
            "school_id" => "required|integer|exists:schools,id",
            "region_id" => "required|integer|exists:regions,id",
            "school_category" => "required|max:100",
            "school_type" => "required|max:100",
            "school_form" => "required|max:100",
            "school_name" => "required|max:100",
            "school_hierarchy_code" => "required|max:100",
            "school_order" => "required|max:100",
        ];
    }

    /**
     * Delete school rule
     *
     * @return string[]
     */
    public static function deleteSchool(): array
    {
        return [
            "id" => "required|integer|exists:schools",
        ];
    }

}
