<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class LessonTitleRules
{

    /**
     * Create general education lesson title
     *
     * @return string[]  upload_file
     */
    #[ArrayShape(["subject_group_id" => "string", "subject_group_sub_system_id" => "string", "class_id" => "string", "subject_id" => "string", "lesson_titles" => "string"])] public static function createGeneralEducation(): array
    {
        $baseRules = [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
            "subject_group_sub_system_id" => "required|integer|exists:sub_systems,id",
            "class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ['lesson_titles' => 'required|file'] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ["lesson_titles" => "required|array"]
            );
        }

        return $baseRules;
    }

    /**
     * Create technical education lesson titles
     *
     * @return string[]
     */
    #[ArrayShape(["subject_group_id" => "string", "subject_group_sub_system_id" => "string", "sub_education_type_id" => "string", "specialty_id" => "string", "specialty_class_id" => "string", "subject_id" => "string", "lesson_titles" => "string"])] public static function createTechnicalEducation(): array
    {
        $baseRules = [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
            "subject_group_sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ['lesson_titles' => 'required|file'] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ["lesson_titles" => "required|array"]
            );
        }

        return $baseRules;
    }

    /**
     * Create teacher training lesson titles
     *
     * @return string[]
     */
    #[ArrayShape(["subject_group_id" => "string", "subject_group_sub_system_id" => "string", "level_id" => "string", "level_class_id" => "string", "subject_id" => "string", "lesson_titles" => "string"])] public static function createTeacherTrainingEducation(): array
    {
        $baseRules = [
            "subject_group_id" => "required|integer|exists:subject_groups,id",
            "subject_group_sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "lesson_titles" => "required|array",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ['lesson_titles' => 'required|file'] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ["lesson_titles" => "required|array"]
            );
        }

        return $baseRules;
    }

    /**
     * Get General Education Lesson Titles
     *
     * @return string[]
     */
 #[ArrayShape(["type" => "string", "request_type" => "string", "sub_system_id" => "string", "education_type_id" => "string", "class_id" => "string", "subject_id" => "string"])] public static function getGeneralEducationLessonTitles(): array
    {
        return [
            "type" => "required|max:5",
            "request_type" => "required|max:50",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "education_type_id" => "required|integer|exists:education_types,id",
            "class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];
    }

    /**
     * Get Technical Education Lesson Titles
     *
     * @return string[]
     */
 #[ArrayShape(["type" => "string", "request_type" => "string", "sub_system_id" => "string", "education_type_id" => "string", "sub_education_type_id" => "string", "specialty_id" => "string", "specialty_class_id" => "string", "subject_id" => "string"])] public static function getTechnicalEducationLessonTitles(): array
    {
        return [
            "type" => "required|max:5",
            "request_type" => "required|max:50",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "education_type_id" => "required|integer|exists:education_types,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];
    }

    /**
     * Get Teacher Training Lesson Titles
     *
     * @return string[]
     */
#[ArrayShape(["type" => "string", "request_type" => "string", "sub_system_id" => "string", "education_type_id" => "string", "level_id" => "string", "level_class_id" => "string", "subject_id" => "string"])] public static function getTeacherTrainingLessonTitle(): array
    {
        return [
            "type" => "required|max:5",
            "request_type" => "required|max:50",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "education_type_id" => "required|integer|exists:education_types,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];
    }

}
