<?php

namespace App\RequestRules\Web;

use App\Enums\ResourceUploadTypeEnum;
use JetBrains\PhpStorm\ArrayShape;

class LessonRules
{
    /**
     * Create general education lesson rule
     *
     * @return array
     */
    public static function createGeneralEducationLesson(): array
    {
        $uploadType = [
            'you_tube_link' => [
                'required',
                'in:' . implode(",", array(ResourceUploadTypeEnum::localServer->value, ResourceUploadTypeEnum::youTube->value))
            ],
        ];

        $baseRules = [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "term_id" => "required|integer|exists:terms,id",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                [
                    'lessons' => 'required|file',
                ] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {
            if (request()->{"upload_type"} == ResourceUploadTypeEnum::localServer->value) {
                return array_merge(
                    $baseRules, [
                    "lesson_title_id" => "required|integer|exists:lesson_titles,id",
                    'lesson_video' => 'required|file|mimetypes:video/mp4',
                ],
                );
            }

            if (request()->{"upload_type"} == ResourceUploadTypeEnum::youTube->value) {
                return array_merge(
                    $baseRules, [
                    "lesson_title_id" => "required|integer|exists:lesson_titles,id",
                    'youtube_lesson_link' => 'required|string',
                ],
                );
            }
        }

        return $baseRules;
    }

    /**
     * Create technical education lesson rule
     *
     * @return array
     */
    public static function createTechnicalEducationLesson(): array
    {
        $baseRules = [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "term_id" => "required|integer|exists:terms,id",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ['lessons' => 'required|file'] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {

            if (request()->{"upload_type"} == ResourceUploadTypeEnum::localServer->value) {
                return array_merge(
                    $baseRules, [
                    'lesson_video' => 'required|file|mimetypes:video/mp4',
                    "lesson_title_id" => "required|integer|exists:lesson_titles,id",
                ],
                );
            }

            if (request()->{"upload_type"} == ResourceUploadTypeEnum::youTube->value) {
                return array_merge(
                    $baseRules, [
                    'youtube_lesson_link' => 'required|string',
                    "lesson_title_id" => "required|integer|exists:lesson_titles,id",
                ],
                );
            }

        }

        return $baseRules;
    }

    /**
     * Create technical education lesson rule
     *
     * @return array
     */
    public static function createTeacherTrainingLesson(): array
    {
        $baseRules = [
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
            "term_id" => "required|integer|exists:terms,id",
        ];

        if (isset(request()->{"upload_file"})) {
            return array_merge(
                $baseRules,
                ['lessons' => 'required|file'] //TODO Validate uploaded excel file
            );
        }

        if (!isset(request()->{"upload_file"})) {

            if (request()->{"upload_type"} == ResourceUploadTypeEnum::localServer->value) {
                return array_merge(
                    $baseRules, [
                    "lesson_title_id" => "required|integer|exists:lesson_titles,id",
                    'lesson_video' => 'required|file|mimetypes:video/mp4',
                ],
                );
            }

            if (request()->{"upload_type"} == ResourceUploadTypeEnum::youTube->value) {
                return array_merge(
                    $baseRules, [
                    "lesson_title_id" => "required|integer|exists:lesson_titles,id",
                    'youtube_lesson_link' => 'required|string',
                ],
                );
            }

        }

        return $baseRules;
    }

    /**
     * Delete
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete($id): array
    {
        return [
            "id" => "required|integer|exists:lessons",
        ];
    }

}
