<?php

namespace App\RequestRules\Web;

class DigitisationRules
{
    /**
     * Get divisions rule
     *
     * @return array
     */
    public static function getDivisions(): array
    {
        return [
            "region_id" => "required|integer|exists:regions,id",
        ];
    }

    /**
     * Add general education digitisation planning
     *
     * @return string[]
     */
   public static function addGenEducPlanning(): array
    {
        return [
            "session_id" => "required|integer|exists:sessions,id",
            "region_id" => "required|integer|exists:regions,id",
            "division_id" => "required|integer|exists:divisions,id",
            "school_id" => "required|integer|exists:schools,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "class_id" => "required|integer|exists:classes,id",
            "subject_id_to_digitise" => "required|integer|exists:subjects,id",
            "stage" => "required|string",
            "lessonTitleIds" => "required|array|exists:lesson_titles,id",
        ];
    }

    /**
     * Add Technical Education digitisation planning
     *
     * @return string[]
     */
    public static function AddTechEducPlanning(): array
    {
        return [
            "session_id" => "required|integer|exists:sessions,id",
            "region_id" => "required|integer|exists:regions,id",
            "division_id" => "required|integer|exists:divisions,id",
            "school_id" => "required|integer|exists:schools,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subject_id_to_digitise" => "required|integer|exists:subjects,id",
            "stage" => "required|string",
            "lessonTitleIds" => "required|array|exists:lesson_titles,id",
        ];
    }

    /**
     * Add Teacher Training Digitisation Planning
     *
     * @return string[]
     */
    public static function addTeachTrainingPlanning(): array
    {
        return [
            "session_id" => "required|integer|exists:sessions,id",
            "region_id" => "required|integer|exists:regions,id",
            "division_id" => "required|integer|exists:divisions,id",
            "school_id" => "required|integer|exists:schools,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subject_id_to_digitise" => "required|integer|exists:subjects,id",
            "stage" => "required|string",
            "lessonTitleIds" => "required|array|exists:lesson_titles,id",
        ];
    }

    /**
     * Get General Education planned lessons
     *
     * @return string[]
     */
     public static function getGenEducPlannedLessons(): array
    {
        return [
            "type" => "required|max:5",
            "session_id" => "required|integer|exists:sessions,id",
            "region_id" => "required|integer|exists:regions,id",
            "division_id" => "required|integer|exists:divisions,id",
            "school_id" => "required|integer|exists:schools,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "education_type_id" => "required|integer|exists:education_types,id",
            "class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];
    }

    /**
     * Get Technical Education planned lessons
     *
     * @return string[]
     */
    public static function getTechEducPlanning(): array
    {
        return [
            "type" => "required|max:5",
            "session_id" => "required|integer|exists:sessions,id",
            "region_id" => "required|integer|exists:regions,id",
            "division_id" => "required|integer|exists:divisions,id",
            "school_id" => "required|integer|exists:schools,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "education_type_id" => "required|integer|exists:education_types,id",
            "sub_education_type_id" => "required|integer|exists:sub_education_types,id",
            "specialty_id" => "required|integer|exists:specialties,id",
            "specialty_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];
    }

    /**
     * Get Teacher Training planned lessons
     *
     * @return string[]
     */
    public static function getTeachTrainingPlanning(): array
    {
        return [
            "type" => "required|max:5",
            "session_id" => "required|integer|exists:sessions,id",
            "region_id" => "required|integer|exists:regions,id",
            "division_id" => "required|integer|exists:divisions,id",
            "school_id" => "required|integer|exists:schools,id",
            "sub_system_id" => "required|integer|exists:sub_systems,id",
            "education_type_id" => "required|integer|exists:education_types,id",
            "level_id" => "required|integer|exists:levels,id",
            "level_class_id" => "required|integer|exists:classes,id",
            "subject_id" => "required|integer|exists:subjects,id",
        ];
    }
}
