<?php

namespace App\RequestRules\Web;

use JetBrains\PhpStorm\ArrayShape;

class ClassRules
{
    /**
     * create rule
     *
     * @return array
     */

    #[ArrayShape(["designation" => "string"])] public static function create(): array
    {
        return  [
            "designation" => "required|max:80",
        ];
    }


    /**
     * Edit rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public  static  function edit($id): array
    {
        return [
            "id" => "required|integer|exists:classes",
        ];
    }


    /**
     * Update rules
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string", "designation" => "string"])] public static  function update(): array
    {
        return [
            "id" => "required|integer|exists:classes",
            "designation" => "required|max:50",
        ];
    }


    /**
     * Delete
     *
     * @return string[]
     */
    #[ArrayShape(["id" => "string"])] public static function delete(): array
    {
        return [
            "id" => "required|integer|exists:classes",
        ];
    }

    /**
     * Get class rule
     *
     * @return array
     */
    #[ArrayShape(["education_type_id" => "string"])] public static function getClasses(): array
    {
        return [
            "education_type_id" => "required|integer|exists:education_types,id",
        ];
    }

    /**
     * Get specialty classes rule
     *
     * @return array
     */
    #[ArrayShape(["specialty_id" => "string"])] public static function getSpecialtyClasses(): array
    {
        return [
            "specialty_id" => "required|integer|exists:specialties,id",
        ];
    }

    /**
     * Get level classes rule
     *
     * @return array
     */
    #[ArrayShape(["level_id" => "string"])] public static function getLevelClasses(): array
    {
        return [
            "level_id" => "required|integer|exists:levels,id",
        ];
    }
}
