<?php

namespace App\Models;

use App\Services\SubjectGroupClassService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SubjectGroupClass extends Model
{
    use HasFactory;
    use SubjectGroupClassService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'subject_group_classes';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['subject_group_id', 'sub_system_id', 'education_type_id', 'sub_education_type_id', 'education_type_class_id', 'specialty_class_id', 'level_class_id'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */
    public function subSystem(): BelongsTo
    {
        return $this->belongsTo(SubSystem::class, 'sub_system_id');
    }

    public function educationType(): BelongsTo
    {
        return $this->belongsTo(EducationType::class, 'education_type_id');
    }

    public function subEducationType(): BelongsTo
    {
        return $this->belongsTo(SubEducationType::class, 'sub_education_type_id');
    }

    public function educationTypeClass(): BelongsTo
    {
        return $this->belongsTo(EducationTypeClass::class, 'education_type_class_id');
    }

    public function specialtyClass(): BelongsTo
    {
        return $this->belongsTo(SpecialtyClass::class, 'specialty_class_id');
    }

    public function levelClass(): BelongsTo
    {
        return $this->belongsTo(LevelClass::class, 'level_class_id');
    }

}
