<?php

namespace App\Models;

use App\Services\SubjectGroupService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubjectGroup extends Model
{
    use HasFactory;
    use SubjectGroupService;
    use SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'subject_groups';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */
    public  function subjectGroupClass(): \Illuminate\Database\Eloquent\Relations\HasOne
    {
        return $this->hasOne(SubjectGroupClass::class);
    }

    public  function subjectGroupSubjects(): BelongsToMany
    {
       return $this->belongsToMany(Subject::class, 'subject_group_subjects', 'subject_group_id', 'subject_id');
    }


}
