<?php

namespace App\Models;

use App\Services\PermissionGroupService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PermissionGroup extends Model
{
    use HasFactory;
    use PermissionGroupService;


    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'permission_groups';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */

    public function permissionCategory(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(PermissionCategory::class, "permission_group_id");
    }
}
