<?php

namespace App\Models;

use App\Services\LessonTitleService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonTitle extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LessonTitleService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'lesson_titles';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'description',
        'subject_group_id',
        'sub_system_id',
        'education_type_id',
        'sub_education_type_id',
        'level_id',
        'specialty_id',
        'class_id',
        'subject_id'
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = [
        'subject_group_id',
        'sub_system_id',
        'education_type_id',
        'sub_education_type_id',
        'level_id',
        'specialty_id',
        'class_id',
        'subject_id',
    ];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */
    public function subjectGroup(): BelongsTo
    {
        return $this->belongsTo(SubjectGroup::class, 'subject_group_id');
    }

    public function subSystem(): BelongsTo
    {
        return $this->belongsTo(SubSystem::class, 'sub_system_id');
    }

    public function educationType(): BelongsTo
    {
        return $this->belongsTo(EducationType::class, 'education_type_id');
    }

    public function subEducationType(): BelongsTo
    {
        return $this->belongsTo(SubEducationType::class, 'sub_education_type_id');
    }

    public function specialty(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Specialty::class, 'specialty_id');
    }

    public function level(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Level::class, 'level_id');
    }

    public function classes(): BelongsTo
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }

    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

}
