<?php

namespace App\Models;

use App\Services\InspectorateService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Inspectorate extends Model
{
    use HasFactory;
    use SoftDeletes;
    use InspectorateService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inspectorates';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['designation'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();

        static::retrieved(function (Inspectorate $inspectorate) {
            $inspectorate->{'designation'} = __(
                $inspectorate->getOriginal('designation')
            );
        });
    }

    /**
     * Relations functions
     */
    public function inspectorateSubjects(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(Subject::class, 'inspectorate_id');
    }

}
