<?php

namespace App\Models;

use App\Services\DigitisationPlanningService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class DigitisationPlanning extends Model
{
    use HasFactory;
    use SoftDeletes;
    use DigitisationPlanningService;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'digitisation_plannings';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'session_id',
        'region_id',
        'division_id',
        'school_id',
        'sub_system_id',
        'education_type_id',
        'sub_education_type_id',
        'specialty_id',
        'level_id',
        'class_id',
        'subject_id',
        'lesson_title_id',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    protected $dates = ['created_at', 'updated_at', 'deleted_at'];

    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    public static function boot()
    {
        parent::boot();
    }

    /**
     * Relations functions
     */
    public function session(): BelongsTo
    {
        return $this->belongsTo(Session::class, 'session_id');
    }

    public function region(): BelongsTo
    {
        return $this->belongsTo(Region::class, 'region_id');
    }

    public function division(): BelongsTo
    {
        return $this->belongsTo(Division::class, 'division_id');
    }

    public function school(): BelongsTo
    {
        return $this->belongsTo(School::class, 'school_id');
    }

    public function subSystem(): BelongsTo
    {
        return $this->belongsTo(SubSystem::class, 'sub_system_id');
    }

    public function educationType(): BelongsTo
    {
        return $this->belongsTo(EducationType::class, 'education_type_id');
    }

    public function subEducationType(): BelongsTo
    {
        return $this->belongsTo(SubEducationType::class, 'sub_education_type_id');
    }

    public function specialty(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Specialty::class, 'specialty_id');
    }

    public function level(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Level::class, 'level_id');
    }

    public function classes(): BelongsTo
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }

    public function subject(): BelongsTo
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

    public function lessonTitle(): BelongsTo
    {
        return $this->belongsTo(LessonTitle::class, 'lesson_title_id');
    }
}
