<?php

namespace App\Libraries;

class ConstantsLib
{

    /**
     * Get languages
     *
     * @return array
     */
    public function getLanguages(): array
    {
        $language = array();
        $language["en"] = __("messages.english");
        $language["fr"] = __("messages.french");

        return $language;
    }

    /**
     * Get gender array
     *
     * @return array
     */
    public function getGender(): array
    {
        $gender = array();
        $gender['Male'] = __("messages.male");
        $gender['Female'] = __("messages.female");

        return $gender;
    }

    /**
     * Get status types
     *
     * @return array
     */
    public function getStatusTypes(): array
    {
        $statusTypes = array();
        $statusTypes[1] = __("messages.yes");
        $statusTypes[0] = __("messages.no");

        return $statusTypes;
    }

    /**
     * Get roles
     *
     * @return array
     */
    public function getRoles (): array
    {

        $roles = array();
        $roles["super_admin"] = __("messages.roles.super_admin");
        $roles["admin"] = __("messages.roles.admin");
        $roles["lesson_validator"] = __("messages.roles.lesson_validator");
        $roles["lesson_recorder"] = __("messages.roles.lesson_recorder");
        $roles["lesson_editor"] = __("messages.roles.lesson_editor");
        $roles["lesson_publisher"] = __("messages.roles.lesson_publisher");
        $roles["ICG"] = __("messages.roles.ICG");
        $roles["CDS"] = __("messages.roles.CDS");
        $roles["IPN"] = __("messages.roles.IPN");
        $roles["ICR"] = __("messages.roles.ICR");
        $roles["IPN"] = __("messages.roles.IPR");
        $roles["teacher"] = __("messages.roles.teacher");

        return $roles;
    }

    /**
     * Get digits
     *
     * @return array
     */
    public function getDigits(): array
    {
        $array = array();
        for ($i = 1; $i <= 10; $i++) {

            $array[$i] = $i;
        }
        return $array;
    }

    /**
     * Get digitisation types
     *
     * @return array
     */
    public function getDigitisationTypes (): array
    {
        $digitisationTypes = array();
        $digitisationTypes['in_class'] = __("messages.in_class");
        $digitisationTypes['at_home'] = __("messages.at_home");
        $digitisationTypes['specialised_centre'] = __("messages.specialised_centre");

        return $digitisationTypes;
    }

    /**
     * Get digitisation tools used
     *
     * @return array
     */
    public function getDigitisationToolsUsed (): array
    {
        $digitisationToolsUsed = array();
        $digitisationToolsUsed['projector'] = __("messages.projector");
        $digitisationToolsUsed['video'] = __("messages.video");
        $digitisationToolsUsed['laptop'] = __("messages.laptop");

        return $digitisationToolsUsed;
    }

    /**
     * Get studios
     *
     * @return array
     */
    public function getStudios(): array
    {
        $studios = array();
        $studios["Studio 1"] = "Studio 1";
        $studios["Studio 2"] = "Studio 2";
        $studios["Studio 3"] = "Studio 3";
        $studios["Studio 4"] = "Studio 4";
        $studios["Studio 5"] = "Studio 5";

        return $studios;
    }

    /**
     * Get exam types
     *
     * @return array
     */
    public function getExamTypes(): array
    {
        $examTypes = array();
        $examTypes["OL"] = "OL";
        $examTypes["AL"] = "AL";
        $examTypes["BEPC"] = "BEPC";
        $examTypes["PROB"] = "PROB";
        $examTypes["BACC"] = "BACC";

        return $examTypes;
    }

    /**
     * Get languages
     *
     * @return array
     */
    public function getResourceDestination(): array
    {
        $resourceDestination  = array();
        $resourceDestination["local_server"] = __("messages.local_server");
        $resourceDestination["you_tube"] = __("messages.you_tube");

        return $resourceDestination;
    }

    /**
     * Get digitisation stage
     *
     * @return array
     */
    public function getDigitisationStage(): array
    {
        $digitisationStage  = array();
        $digitisationStage["planning"] = __("messages.planning");
        $digitisationStage["implementation"] = __("messages.implementation");

        return $digitisationStage;
    }

}
