<?php

namespace App\Http\Controllers\Web\Admin;

use App\Http\Controllers\Controller;
use App\Models\Inspectorate;
use App\Models\Lesson;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;

class DashboardController extends Controller
{
    /**
     * Display dashboard view
     *
     * @return Application|Factory|View
     *
     */
   public function index(): View|Factory|Application
   {
       $lessonStatistics = Lesson::lessonStatistics();
       $inspectorates = Inspectorate::allInspectorates();

       $inspectorateArray = array();
       foreach ($inspectorates as $inspectorate) {
           $inspectorateArray[] = array(
               "designation" => $inspectorate->{"designation"},
               "number_of_lessons" => Lesson::inspectorateStatistics($inspectorate->{"id"}),
           );
       }

       return view("admin.dashboard", compact("lessonStatistics", "inspectorates", "inspectorateArray"));
   }


}
