<?php

use App\Enums\LogLevelEnum;
use App\Models\Classes;
use App\Models\EducationType;
use App\Models\Level;
use App\Models\Specialty;
use App\Models\SubEducationType;
use App\Models\Subject;
use App\Models\SubSystem;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Log;

if (!function_exists('log_level')) {
    function log_level(string $message, LogLevelEnum $level, array $data = [])
    {
        if ($level === LogLevelEnum::emergency) {
            Log::emergency($message, $data);
        }

        if ($level === LogLevelEnum::alert) {
            Log::alert($message, $data);
        }

        if ($level === LogLevelEnum::critical) {
            Log::critical($message, $data);
        }

        if ($level === LogLevelEnum::error) {
            Log::error($message, $data);
        }

        if ($level === LogLevelEnum::warning) {
            Log::warning($message, $data);
        }

        if ($level === LogLevelEnum::notice) {
            Log::notice($message, $data);
        }

        if ($level === LogLevelEnum::info) {
            Log::info($message, $data);
        }

        if ($level === LogLevelEnum::debug) {
            Log::debug($message, $data);
        }
    }
}

if (!function_exists('log_debug')) {
    function log_debug(Exception $exception = null, string $prefix = null, array $data = [], LogLevelEnum $level = LogLevelEnum::info)
    {
        $message = $exception !== null
            ? sprintf(
                'FILE::%s, LINE::%s, MESSAGE:: %s',
                $exception->getFile(),
                $exception->getLine(),
                $exception->getMessage()
            )
            : '';

        if ($prefix !== null) {
            log_level($prefix . ' ::: ' . $message, $level, $data);
        } else {
            log_level($message, $level, $data);
        }
    }
}

if(! function_exists('sub_system')) {
    function sub_system(int $subSystemId): array|string
    {
        $subSystem = SubSystem::query()->where('id',$subSystemId)->first();

        $result = strtolower($subSystem->{"designation"});
        return str_replace(' ', '-', $result);
    }
}

if(! function_exists('education_type')) {
    function education_type(int $educationTypeId): array|string
    {
        $educationType = EducationType::query()->where('id',$educationTypeId)->first();

        $result = strtolower($educationType->{"designation"});
        return str_replace(' ', '-', $result);
    }
}

if(! function_exists('sub_education_type')) {
    function sub_education_type(int $subEducationTypeId): array|string
    {
        $subEducationType = SubEducationType::query()->where('id',$subEducationTypeId)->first();

        $result = strtolower($subEducationType->{"designation"});
        return str_replace(' ', '-', $result);
    }
}

if(! function_exists('specialty')) {
    function specialty(int $specialtyId): array|string
    {
        $specialty = Specialty::query()->where('id',$specialtyId)->first();

        $result = strtolower($specialty->{"designation"});
        return str_replace(' ', '-', $result);
    }
}

if(! function_exists('level')) {
    function level(int $specialtyId): array|string
    {
        $level = Level::query()->where('id',$specialtyId)->first();

        $result = strtolower($level->{"designation"});
        return str_replace(' ', '-', $result);
    }
}

if(! function_exists('classes')) {
    function classes(int $classId): array|string
    {
        $class = Classes::query()->where('id',$classId)->first();

        $result = strtolower($class->{"designation"});
        return str_replace(' ', '-',$result);
    }
}

if(! function_exists('subject')) {
    function subject(int $subjectId): array|string
    {
        $subject = Subject::query()->where('id',$subjectId)->first();

        $result = strtolower($subject->{"designation"});
        return str_replace(' ', '-', $result);
    }
}

if (!function_exists('api_response')) {
    function api_response(int $code, string $message = null, $data = null): Response|Application|ResponseFactory
    {
        return response([
            'code' => $code,
            'message' => $message,
            'data' => $data
        ]);
    }
}
